/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.people.config.JustOpaqueTokenIntrospector;
import de.justsoftware.people.config.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\nH\u0017\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/people/config/WebSecurityConfiguration;", "", "()V", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "authenticationProcessingFilter", "Lde/justsoftware/jwtfilter/JwtAuthenticationProcessingFilter;", "clientId", "", "clientSecret", "checkTokenEndpoint", "Companion", "people-api"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INTERNAL_API = "/internal/**";
    @NotNull
    private static final OrRequestMatcher ALLOW_COOKIE_ONLY_AUTH = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/api/profiles/export")));
    @NotNull
    private static final String[] SWAGGER_RESOURCES;

    @Bean
    @NotNull
    public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http, @NotNull JwtAuthenticationProcessingFilter authenticationProcessingFilter, @Value(value="${just.people.oauth2.resource.client_id}") @NotNull String clientId, @Value(value="${just.people.oauth2.resource.client_secret}") @NotNull String clientSecret, @Value(value="${just.people.oauth2.resource.check_token_endpoint}") @NotNull String checkTokenEndpoint) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)authenticationProcessingFilter, (String)"authenticationProcessingFilter");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        authenticationProcessingFilter.applyIgnoreFilterMatcher(arg_0 -> ((AntPathRequestMatcher)new AntPathRequestMatcher(INTERNAL_API)).matches(arg_0)).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)ALLOW_COOKIE_ONLY_AUTH);
        Object object = http.sessionManagement(WebSecurityConfiguration::securityFilterChain$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::securityFilterChain$lambda$1).anonymous(Customizer.withDefaults()).headers(WebSecurityConfiguration::securityFilterChain$lambda$2).authorizeHttpRequests(WebSecurityConfiguration::securityFilterChain$lambda$3).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.securityFilterChain$lambda$5(checkTokenEndpoint, clientId, clientSecret, arg_0)).addFilterAfter((Filter)authenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void securityFilterChain$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void securityFilterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void securityFilterChain$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void securityFilterChain$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)SWAGGER_RESOURCES);
        spreadBuilder.add((Object)INTERNAL_API);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]))).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    private static final void securityFilterChain$lambda$5$lambda$4(String $checkTokenEndpoint, String $clientId, String $clientSecret, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector($checkTokenEndpoint, $clientId, $clientSecret);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void securityFilterChain$lambda$5(String $checkTokenEndpoint, String $clientId, String $clientSecret, OAuth2ResourceServerConfigurer resourceServerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        Intrinsics.checkNotNullParameter((Object)resourceServerCustomizer, (String)"resourceServerCustomizer");
        resourceServerCustomizer.opaqueToken(arg_0 -> WebSecurityConfiguration.securityFilterChain$lambda$5$lambda$4($checkTokenEndpoint, $clientId, $clientSecret, arg_0));
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

