/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.controller;

import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/notification"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/notificationservice/controller/InternalNotificationController;", "", "notificationService", "Lde/justsoftware/notificationservice/business/NotificationService;", "(Lde/justsoftware/notificationservice/business/NotificationService;)V", "getOpenNotificationCounts", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "", "profileIds", "", "notification-service"})
public class InternalNotificationController {
    @NotNull
    private final NotificationService notificationService;

    public InternalNotificationController(@NotNull NotificationService notificationService) {
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        this.notificationService = notificationService;
    }

    @PostMapping(value={"/open"})
    @NotNull
    public Map<ProfileId, Integer> getOpenNotificationCounts(@RequestBody @NotNull List<? extends ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.notificationService.getNotificationCounts((Collection)profileIds, NotificationStatus.OPEN);
    }
}

