/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.NotificationConcern;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.business.BrowserPushService;
import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.exception.NotificationNotFoundException;
import de.justsoftware.notificationservice.model.Notification;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.model.NotificationsCount;
import de.justsoftware.notificationservice.model.Profile;
import de.justsoftware.notificationservice.model.event.ProfileUpdateEvent;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.CollectionUtilKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017JH\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010'\u001a\u00020\u00132\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001d2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0017J\u0018\u0010,\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020.0\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010/\u001a\u00020\"H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/justsoftware/notificationservice/business/NotificationService;", "", "notificationRepository", "Lde/justsoftware/notificationservice/persistence/NotificationRepository;", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "browserPushService", "Lde/justsoftware/notificationservice/business/BrowserPushService;", "(Lde/justsoftware/notificationservice/persistence/NotificationRepository;Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;Lde/justsoftware/notificationservice/business/BrowserPushService;)V", "archiveAllUnmarkedNotifications", "", "Ljava/util/UUID;", "receiverId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "concern", "Lde/justsoftware/notificationclient/model/NotificationConcern;", "app", "", "archiveNotification", "", "notificationId", "getNotificationCounts", "", "", "profileIds", "", "status", "Lde/justsoftware/notificationservice/model/NotificationStatus;", "getNotifications", "", "Lde/justsoftware/notificationservice/model/Notification;", "locale", "Ljava/util/Locale;", "before", "Ljava/time/Instant;", "maxElements", "getNotificationsCount", "Lde/justsoftware/notificationservice/model/NotificationsCount;", "markNotification", "moveToOpen", "notificationIds", "onProfileUpdates", "event", "Lde/justsoftware/notificationservice/model/event/ProfileUpdateEvent;", "unmarkNotification", "updated", "", "since", "notification-service"})
@SourceDebugExtension(value={"SMAP\nNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationService.kt\nde/justsoftware/notificationservice/business/NotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtil.kt\nde/justsoftware/notificationservice/util/CollectionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,159:1\n1549#2:160\n1620#2,3:161\n1620#2,3:165\n1238#2,4:171\n17#3:164\n1#4:168\n468#5:169\n414#5:170\n*S KotlinDebug\n*F\n+ 1 NotificationService.kt\nde/justsoftware/notificationservice/business/NotificationService\n*L\n91#1:160\n91#1:161,3\n114#1:165,3\n116#1:171,4\n114#1:164\n116#1:169\n116#1:170\n*E\n"})
public class NotificationService {
    @NotNull
    private final NotificationRepository notificationRepository;
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    @NotNull
    private final BrowserPushService browserPushService;

    public NotificationService(@NotNull NotificationRepository notificationRepository, @NotNull DeliveryStatusRepository deliveryStatusRepository, @NotNull BrowserPushService browserPushService) {
        Intrinsics.checkNotNullParameter((Object)notificationRepository, (String)"notificationRepository");
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)browserPushService, (String)"browserPushService");
        this.notificationRepository = notificationRepository;
        this.deliveryStatusRepository = deliveryStatusRepository;
        this.browserPushService = browserPushService;
    }

    @NotNull
    public List<Notification> getNotifications(@NotNull Locale locale, @NotNull ProfileId receiverId, @NotNull NotificationStatus status, @NotNull NotificationConcern concern, @Nullable String app, @NotNull Instant before, int maxElements) {
        Page page;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)concern, (String)"concern");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        if (app == null) {
            var10_8 = new String[]{"notification.timestamp"};
            var9_9 = this.deliveryStatusRepository.findNotifications(receiverId.toString(), status, before, (Set)NotificationType.forConcern((NotificationConcern)concern), (Pageable)PageRequest.of((int)0, (int)maxElements, (Sort.Direction)Sort.Direction.DESC, (String[])var10_8));
            Intrinsics.checkNotNull((Object)var9_9);
            page = var9_9;
        } else {
            var10_8 = new String[]{"notification.timestamp"};
            var9_9 = this.deliveryStatusRepository.findNotificationsByApp(receiverId.toString(), status, before, (Set)NotificationType.forConcern((NotificationConcern)concern), app, (Pageable)PageRequest.of((int)0, (int)maxElements, (Sort.Direction)Sort.Direction.DESC, (String[])var10_8));
            Intrinsics.checkNotNull((Object)var9_9);
            page = var9_9;
        }
        Page deliveryStatus = page;
        Stream stream = deliveryStatus.get();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"get(...)");
        Set notificationIds2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)getNotifications.notificationIds.1.INSTANCE)));
        ImmutableMap immutableMap = this.notificationRepository.findByIds(notificationIds2);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"findByIds(...)");
        ImmutableMap notifications = immutableMap;
        Stream stream2 = deliveryStatus.get();
        Intrinsics.checkNotNullExpressionValue((Object)stream2, (String)"get(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence((Stream)stream2), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)));
    }

    public void archiveNotification(@NotNull UUID notificationId, @NotNull ProfileId receiverId) throws NotificationNotFoundException {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        int updated = this.deliveryStatusRepository.setArchived(receiverId.toString(), notificationId, Instant.now());
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this.deliveryStatusRepository.flush();
        this.browserPushService.pushNotificationsUpdated(receiverId);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Set<UUID> archiveAllUnmarkedNotifications(@NotNull ProfileId receiverId, @NotNull NotificationConcern concern, @Nullable String app) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)concern, (String)"concern");
        ImmutableSet immutableSet = NotificationType.forConcern((NotificationConcern)concern);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"forConcern(...)");
        ImmutableSet types = immutableSet;
        if (app == null) {
            var6_5 = this.deliveryStatusRepository.findAllOpenAndUnmarked(receiverId.toString(), (Set)types);
            Intrinsics.checkNotNull((Object)var6_5);
            list = var6_5;
        } else {
            var6_5 = this.deliveryStatusRepository.findAllOpenAndUnmarkedByApp(receiverId.toString(), (Set)types, app);
            Intrinsics.checkNotNull((Object)var6_5);
            list = var6_5;
        }
        List allOpenAndUnmarked = list;
        Iterable iterable = allOpenAndUnmarked;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbDeliveryStatus dbDeliveryStatus = (DbDeliveryStatus)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getNotificationId());
        }
        Set notificationIds2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)notificationIds2).isEmpty()) {
            this.deliveryStatusRepository.setArchived(notificationIds2, receiverId.toString(), Instant.now());
            this.deliveryStatusRepository.flush();
            this.browserPushService.pushNotificationsUpdated(receiverId);
        }
        return notificationIds2;
    }

    @Transactional
    @NotNull
    public NotificationsCount getNotificationsCount(@NotNull ProfileId receiverId) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        int open = this.deliveryStatusRepository.countByReceiverIdAndStatus(receiverId.toString(), NotificationStatus.OPEN);
        int archived = this.deliveryStatusRepository.countByReceiverIdAndStatus(receiverId.toString(), NotificationStatus.ARCHIVED);
        return new NotificationsCount(open, archived);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ProfileId, Integer> getNotificationCounts(@NotNull Collection<? extends ProfileId> profileIds, @NotNull NotificationStatus status) {
        void $this$mapKeysTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Iterable iterable = profileIds;
        boolean $i$f$mapToSet = false;
        void var6_7 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(p0.toString());
        }
        Object it = (Set)destination$iv$iv;
        boolean bl = false;
        ImmutableMap immutableMap = this.deliveryStatusRepository.countByReceiverIdsAndStatus((Set)it, status);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"let(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        it = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            ProfileId profileId;
            void it$iv$iv;
            void entry;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)ProfileId.fromString((String)((String)entry.getKey())), (String)"fromString(...)");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object object2 = object;
            boolean bl4 = false;
            Object v = it$iv$iv.getValue();
            object2.put(profileId, v);
        }
        return destination$iv$iv2;
    }

    @Transactional
    @NotNull
    public Map<String, Boolean> updated(@NotNull ProfileId receiverId, @NotNull Instant since) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        boolean updated = this.deliveryStatusRepository.countUpdatesForReceiverSinceTimestamp(receiverId.toString(), since) > 0;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"updated", (Object)updated));
    }

    public void markNotification(@NotNull UUID notificationId, @NotNull ProfileId receiverId) throws NotificationNotFoundException {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        int updated = this.deliveryStatusRepository.mark(receiverId.toString(), notificationId, Instant.now());
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this.browserPushService.pushNotificationsUpdated(receiverId);
    }

    public void unmarkNotification(@NotNull UUID notificationId, @NotNull ProfileId receiverId) throws NotificationNotFoundException {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        int updated = this.deliveryStatusRepository.unmark(receiverId.toString(), notificationId, Instant.now());
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this.browserPushService.pushNotificationsUpdated(receiverId);
    }

    public void moveToOpen(@NotNull List<UUID> notificationIds2, @NotNull ProfileId receiverId) {
        Intrinsics.checkNotNullParameter(notificationIds2, (String)"notificationIds");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        this.deliveryStatusRepository.setOpen(notificationIds2, receiverId.toString(), Instant.now());
        this.browserPushService.pushNotificationsUpdated(receiverId);
    }

    @EventListener
    @Transactional
    public void onProfileUpdates(@NotNull ProfileUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Profile profile = event.getProfile();
        if (profile.getDeleted()) {
            this.deliveryStatusRepository.deleteByReceiverId(profile.getId().toString());
        }
    }
}

