/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.CsvExport;
import de.justsoftware.news.domain.poll.CsvExportEntry;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollCsvExportService$fetchAndBuildCsvExportEntries$;
import de.justsoftware.news.domain.poll.PollExportLanguage;
import de.justsoftware.news.domain.poll.PollPrivacy;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.ProfileId;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0017J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020$0\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0012R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/news/domain/poll/PollCsvExportService;", "", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "(Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/user/ProfileRepo;)V", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "getDateTimeFormatter", "()Ljava/time/format/DateTimeFormatter;", "buildHeadersRow", "", "", "isAnonymousExport", "", "question", "answers", "language", "Lde/justsoftware/news/domain/poll/PollExportLanguage;", "buildRow", "rowData", "Lde/justsoftware/news/domain/poll/CsvExportEntry;", "export", "Lde/justsoftware/news/domain/poll/CsvExport;", "pollId", "Lde/justsoftware/news/id/PollId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "fetchAndBuildCsvExportEntries", "Lde/justsoftware/news/domain/poll/PollAnswer;", "getNoTranslation", "getYesTranslation", "news-service"})
@SourceDebugExtension(value={"SMAP\nPollCsvExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollCsvExportService.kt\nde/justsoftware/news/domain/poll/PollCsvExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1549#2:181\n1620#2,3:182\n1549#2:186\n1620#2,3:187\n1549#2:190\n1620#2,3:191\n1655#2,8:194\n1549#2:202\n1620#2,3:203\n1045#2:206\n1559#2:207\n1590#2,3:208\n1549#2:211\n1620#2,2:212\n766#2:214\n857#2,2:215\n1622#2:217\n1593#2:218\n1549#2:219\n1620#2,3:220\n1#3:185\n*S KotlinDebug\n*F\n+ 1 PollCsvExportService.kt\nde/justsoftware/news/domain/poll/PollCsvExportService\n*L\n56#1:181\n56#1:182,3\n61#1:186\n61#1:187,3\n103#1:190\n103#1:191,3\n106#1:194,8\n111#1:202\n111#1:203,3\n115#1:206\n116#1:207\n116#1:208,3\n122#1:211\n122#1:212,2\n124#1:214\n124#1:215,2\n122#1:217\n116#1:218\n135#1:219\n135#1:220,3\n*E\n"})
public class PollCsvExportService {
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final DateTimeFormatter dateTimeFormatter;

    public PollCsvExportService(@NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo, @NotNull PostRepo postRepo, @NotNull ProfileRepo profileRepo) {
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
        this.postRepo = postRepo;
        this.profileRepo = profileRepo;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @NotNull
    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public CsvExport export(@NotNull PollId pollId, @NotNull PollExportLanguage language, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Poll poll = this.pollRepo.getById(pollId);
        Post post = this.postRepo.getByIdAndDeletedFalse(poll.getPostId());
        authContext.checkPostAction(post.getId(), PostAction.POLL_EXPORT);
        List answers = this.pollAnswerRepo.findAllByPollId(poll.getId());
        boolean isAnonymousExport = poll.getPrivacy() == PollPrivacy.ANONYMOUS || poll.getPrivacy() == PollPrivacy.MANAGERS_ONLY && !authContext.mayManage((ItemId)post.getId());
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            CsvExport csvExport;
            StringWriter stringWriter = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new CsvMapper().writer((FormatSchema)CsvSchema.emptySchema().withColumnSeparator(';')).writeValues((Writer)stringWriter);
            Throwable throwable2 = null;
            try {
                void $this$mapTo$iv$iv;
                CsvExportEntry it;
                Collection<String> collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                SequenceWriter sequenceWriter = (SequenceWriter)closeable2;
                boolean bl2 = false;
                Iterable iterable = answers;
                String string = poll.getQuestion();
                boolean bl3 = isAnonymousExport;
                Object object = this;
                boolean $i$f$map = false;
                void var21_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.getText());
                }
                collection = (List)destination$iv$iv;
                List it2 = object.buildHeadersRow(bl3, string, (List)collection, language);
                boolean $i$a$-let-PollCsvExportService$export$1$1$32 = false;
                sequenceWriter.write((Object)it2);
                $this$map$iv = this.fetchAndBuildCsvExportEntries(answers, isAnonymousExport);
                $i$f$map = false;
                Iterable $i$a$-let-PollCsvExportService$export$1$1$32 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (CsvExportEntry)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    object.add(this.buildRow(it, language));
                }
                it = (List)destination$iv$iv;
                boolean bl6 = false;
                sequenceWriter.write((Object)it);
                String string2 = post.getTitle();
                String string3 = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                csvExport = new CsvExport(string2, ((Object)StringsKt.trim((CharSequence)string3)).toString());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            CsvExport csvExport2 = csvExport;
            return csvExport2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private String getYesTranslation(PollExportLanguage language) {
        return language == PollExportLanguage.DE ? "ja" : "yes";
    }

    private String getNoTranslation(PollExportLanguage language) {
        return language == PollExportLanguage.DE ? "nein" : "no";
    }

    private List<String> buildHeadersRow(boolean isAnonymousExport, String question, List<String> answers, PollExportLanguage language) {
        List list;
        if (language == PollExportLanguage.DE) {
            if (isAnonymousExport) {
                Object[] objectArray = new String[]{"Teilnehmer-Nr.", "Datum der Antwort", question};
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
            } else {
                Object[] objectArray = new String[]{"Teilnehmer-Nr.", "Datum der Antwort", "Profile-ID", "Titel", "Vorname", "Nachname", "Nachtitel", question};
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
            }
        } else if (isAnonymousExport) {
            Object[] objectArray = new String[]{"No.", "Date of response", question};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
        } else {
            Object[] objectArray = new String[]{"No.", "Date of response", "Profile ID", "Title", "First name", "Last name", "Additional title", question};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)answers);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<CsvExportEntry> fetchAndBuildCsvExportEntries(List<PollAnswer> answers, boolean isAnonymousExport) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Iterable $this$sortedBy$iv;
        Collection destination$iv$iv;
        Set set;
        void $this$distinctBy$iv;
        PollVote it;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = answers;
        Object object = this.pollVoteRepo;
        boolean $i$f$map22 = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set votesForAllAnswers = object.findByAnswerIdIn(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        Iterable $i$f$map22 = votesForAllAnswers;
        boolean $i$f$distinctBy2 = false;
        HashSet<ProfileId> set$iv = new HashSet<ProfileId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            it = (PollVote)e$iv;
            boolean bl = false;
            ProfileId key$iv = it.getProfileId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctVotes = list$iv;
        if (isAnonymousExport) {
            set = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable $i$f$distinctBy2 = distinctVotes;
            boolean $i$f$map = false;
            list$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                PollVote pollVote = (PollVote)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it2.getProfileId());
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            set = this.profileRepo.findAllProfilesById((Collection)it3);
        }
        Set voters = set;
        Iterable $this$map$iv2 = distinctVotes;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new fetchAndBuildCsvExportEntries$$inlined$sortedBy$1()));
        boolean $i$f$mapIndexed = false;
        void bl = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Object object2;
            void var20_36;
            Instant instant;
            void vote;
            Iterable iterable2;
            block11: {
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PollVote pollVote = (PollVote)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv;
                boolean bl2 = false;
                iterable2 = voters;
                instant = vote.getVoteDate();
                var20_36 = index;
                Iterable iterable3 = iterable2;
                for (Object t : iterable3) {
                    Profile it4 = (Profile)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it4.getId(), (Object)vote.getProfileId())) continue;
                    object2 = t;
                    break block11;
                }
                object2 = null;
            }
            Profile profile = object2;
            iterable2 = answers;
            profile = profile;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                Object v2;
                void answer;
                block12: {
                    void $this$filterTo$iv$iv;
                    PollAnswer pollAnswer = (PollAnswer)item$iv$iv2;
                    collection = destination$iv$iv3;
                    boolean bl4 = false;
                    Iterable $this$filter$iv = votesForAllAnswers;
                    boolean $i$f$filter = false;
                    Iterable iterable4 = $this$filter$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        PollVote it5 = (PollVote)element$iv$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it5.getAnswerId(), (Object)answer.getId())) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    List votesForAnswer = (List)destination$iv$iv4;
                    iterable4 = votesForAnswer;
                    for (Object t : iterable4) {
                        PollVote it6 = (PollVote)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)it6.getProfileId(), (Object)vote.getProfileId())) continue;
                        v2 = t;
                        break block12;
                    }
                    v2 = null;
                }
                PollVote voteOfCurrentProfile = v2;
                boolean hasVoted = voteOfCurrentProfile != null;
                collection.add(new Pair((Object)answer.getId(), (Object)hasVoted));
            }
            Collection<Pair> collection2 = collection = (List)destination$iv$iv3;
            Profile profile2 = profile;
            Instant instant2 = instant;
            void var46_65 = var20_36;
            object.add(new CsvExportEntry((int)var46_65, instant2, profile2, (List)collection2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> buildRow(CsvExportEntry rowData, PollExportLanguage language) {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = rowData.getVotes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Boolean)it.getSecond()).booleanValue() ? this.getYesTranslation(language) : this.getNoTranslation(language));
        }
        List translatedVotes = (List)destination$iv$iv;
        String index = String.valueOf(rowData.getIndex());
        String voteDate = this.getDateTimeFormatter().format(rowData.getVoteDate());
        Profile profile = rowData.getProfile();
        String question = "";
        if (profile == null) {
            Object[] objectArray = new String[]{index, voteDate, question};
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)translatedVotes);
        } else {
            Object[] objectArray = new String[8];
            objectArray[0] = index;
            objectArray[1] = voteDate;
            objectArray[2] = profile.getId().toTypedString();
            String string = profile.getPrefix();
            if (string == null) {
                string = "";
            }
            objectArray[3] = string;
            objectArray[4] = profile.getFirstName();
            objectArray[5] = profile.getLastName();
            String string2 = profile.getSuffix();
            if (string2 == null) {
                string2 = "";
            }
            objectArray[6] = string2;
            objectArray[7] = question;
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)translatedVotes);
        }
        return list;
    }
}

