/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migration;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.migration.ExternalMigrationService;
import de.justsoftware.news.graphql.generated.types.ExternalMigrationInput;
import de.justsoftware.news.graphql.generated.types.MigrationResult;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@DgsComponent
@ConditionalOnProperty(name={"just.news.externalMigration.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/justsoftware/news/domain/migration/ExternalMigrationFetcher;", "", "externalMigrationService", "Lde/justsoftware/news/domain/migration/ExternalMigrationService;", "(Lde/justsoftware/news/domain/migration/ExternalMigrationService;)V", "getExternalMigrationService", "()Lde/justsoftware/news/domain/migration/ExternalMigrationService;", "migrate", "Lde/justsoftware/news/graphql/generated/types/MigrationResult;", "input", "Lde/justsoftware/news/graphql/generated/types/ExternalMigrationInput;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "news-service"})
public class ExternalMigrationFetcher {
    @NotNull
    private final ExternalMigrationService externalMigrationService;

    public ExternalMigrationFetcher(@NotNull ExternalMigrationService externalMigrationService) {
        Intrinsics.checkNotNullParameter((Object)externalMigrationService, (String)"externalMigrationService");
        this.externalMigrationService = externalMigrationService;
    }

    @NotNull
    public ExternalMigrationService getExternalMigrationService() {
        return this.externalMigrationService;
    }

    @DgsMutation(field="externalMigration")
    @NotNull
    public MigrationResult migrate(@InputArgument @NotNull ExternalMigrationInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return this.getExternalMigrationService().migrate(input, authContext);
    }
}

