/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.news.service;

import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.news.generated.fragment.ConfigFragment;
import de.justsoftware.mobile.gateway.news.model.AddPostData;
import de.justsoftware.mobile.gateway.news.model.Channel;
import de.justsoftware.mobile.gateway.news.model.Comment;
import de.justsoftware.mobile.gateway.news.model.CommentContent;
import de.justsoftware.mobile.gateway.news.model.Poll;
import de.justsoftware.mobile.gateway.news.model.Post;
import de.justsoftware.mobile.gateway.news.model.PostContent;
import de.justsoftware.mobile.gateway.news.model.PostTranslation;
import de.justsoftware.mobile.gateway.news.model.UpdatePostData;
import de.justsoftware.mobile.gateway.news.service.NewsApiGatewayService;
import de.justsoftware.mobile.gateway.news.service.NewsService;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.util.LikesKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\bH\u0016J>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00152\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0012J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020#0\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010-\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010/\u001a\u00020\u0018H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u00101\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u00102\u001a\u00020 H\u0016J \u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u0002052\u0006\u00106\u001a\u00020\bH\u0016J\u0018\u00107\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u00108\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u001a\u0010:\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010;\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010>\u001a\u00020?2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010@\u001a\u00020\b2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J'\u0010B\u001a\u0002HC\"\u0004\b\u0000\u0010C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u0002HC0EH\u0012\u00a2\u0006\u0002\u0010GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lde/justsoftware/mobile/gateway/news/service/NewsService;", "", "gatewayService", "Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;", "(Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;)V", "addComment", "Lde/justsoftware/mobile/gateway/news/model/Comment;", "postId", "", "parentId", "referenceId", "content", "Lde/justsoftware/mobile/gateway/news/model/CommentContent;", "addPost", "Lde/justsoftware/mobile/gateway/news/model/Post;", "channelId", "addPostData", "Lde/justsoftware/mobile/gateway/news/model/AddPostData;", "locale", "Ljava/util/Locale;", "deleteComment", "", "commentId", "deletePost", "", "getChannel", "Lde/justsoftware/mobile/gateway/news/model/Channel;", "getChannelPosts", "offset", "", "limit", "scheduled", "", "pinned", "getChannelSubscribers", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "getChannelSubscribersCount", "getChannels", "getComment", "getCommentLikers", "getComments", "getFeed", "getPost", "getPostLikers", "likeComment", "likePost", "markFeedAsRead", "markPostAsRead", "subscribe", "notificationsEnabled", "translatePost", "Lde/justsoftware/mobile/gateway/news/model/PostTranslation;", "Lde/justsoftware/mobile/gateway/news/model/PostContent;", "targetLanguage", "unlikeComment", "unlikePost", "unsubscribe", "updateComment", "updatePost", "updatePostData", "Lde/justsoftware/mobile/gateway/news/model/UpdatePostData;", "voteForPoll", "Lde/justsoftware/mobile/gateway/news/model/Poll;", "pollId", "answerIds", "withConfig", "T", "block", "Lkotlin/Function1;", "Lde/justsoftware/mobile/gateway/news/generated/fragment/ConfigFragment;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNewsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsService.kt\nde/justsoftware/mobile/gateway/news/service/NewsService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,325:1\n179#2,2:326\n*S KotlinDebug\n*F\n+ 1 NewsService.kt\nde/justsoftware/mobile/gateway/news/service/NewsService\n*L\n313#1:326,2\n*E\n"})
public class NewsService {
    @NotNull
    private final NewsApiGatewayService gatewayService;

    public NewsService(@NotNull NewsApiGatewayService gatewayService) {
        Intrinsics.checkNotNullParameter((Object)gatewayService, (String)"gatewayService");
        this.gatewayService = gatewayService;
    }

    @NotNull
    public List<Post> getFeed(int offset, int limit, boolean pinned, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (List)this.withConfig((Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void markFeedAsRead() {
        this.gatewayService.markFeedAsRead();
    }

    @NotNull
    public List<Channel> getChannels() {
        return Channel.Companion.toChannels(this.gatewayService.getChannels());
    }

    @NotNull
    public Channel subscribe(@NotNull String channelId, boolean notificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return Channel.Companion.toChannel(this.gatewayService.subscribe(channelId, notificationsEnabled));
    }

    public static /* synthetic */ Channel subscribe$default(NewsService newsService, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: subscribe");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return newsService.subscribe(string, bl);
    }

    @NotNull
    public Channel unsubscribe(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return Channel.Companion.toChannel(this.gatewayService.unsubscribe(channelId));
    }

    @NotNull
    public Channel getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return Channel.Companion.toChannel(this.gatewayService.getChannel(channelId));
    }

    @NotNull
    public List<Post> getChannelPosts(@NotNull String channelId, int offset, int limit, boolean scheduled, boolean pinned, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (List)this.withConfig((Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public Post addPost(@NotNull String channelId, @NotNull AddPostData addPostData, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)addPostData, (String)"addPostData");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (Post)this.withConfig((Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public Post getPost(@NotNull String postId, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (Post)this.withConfig((Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public Post updatePost(@NotNull String postId, @NotNull UpdatePostData updatePostData, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updatePostData, (String)"updatePostData");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (Post)this.withConfig((Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.gatewayService.deletePost(postId);
    }

    @NotNull
    public List<Comment> getComments(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return Comment.Companion.CommentFragmentsToComments(this.gatewayService.getComments(postId));
    }

    @NotNull
    public Comment addComment(@NotNull String postId, @Nullable String parentId, @Nullable String referenceId, @NotNull CommentContent content) {
        Comment comment;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Comment comment2 = comment = Comment.Companion.toComment(this.gatewayService.addComment(postId, parentId, referenceId, content));
        if (comment2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return comment2;
    }

    public static /* synthetic */ Comment addComment$default(NewsService newsService, String string, String string2, String string3, CommentContent commentContent, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addComment");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return newsService.addComment(string, string2, string3, commentContent);
    }

    @Nullable
    public Comment updateComment(@NotNull String commentId, @NotNull CommentContent content) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Comment.Companion.toComment(this.gatewayService.updateComment(commentId, content));
    }

    @NotNull
    public List<Comment> deleteComment(@NotNull String postId, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        this.gatewayService.deleteComment(commentId);
        return this.getComments(postId);
    }

    @NotNull
    public Post likePost(@NotNull String postId, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.gatewayService.like(postId);
        return this.getPost(postId, locale);
    }

    @NotNull
    public Post unlikePost(@NotNull String postId, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.gatewayService.unlike(postId);
        return this.getPost(postId, locale);
    }

    @NotNull
    public Comment likeComment(@NotNull String postId, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        this.gatewayService.like(commentId);
        return this.getComment(postId, commentId);
    }

    @NotNull
    public Comment unlikeComment(@NotNull String postId, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        this.gatewayService.unlike(commentId);
        return this.getComment(postId, commentId);
    }

    public void markPostAsRead(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.gatewayService.markPostAsRead(postId);
    }

    @NotNull
    public Poll voteForPoll(@NotNull String postId, @NotNull String pollId, @NotNull List<String> answerIds, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(answerIds, (String)"answerIds");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return (Poll)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public List<Profile> getChannelSubscribers(@NotNull String channelId, int offset, int limit, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List list = this.gatewayService.getChannelSubscribers(channelId, offset, limit, query);
        List list2 = list != null ? Profile.Companion.toProfiles(list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public int getChannelSubscribersCount(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Integer n = this.gatewayService.getChannelSubscribersCount(channelId);
        return n != null ? n : 0;
    }

    @NotNull
    public List<Profile> getPostLikers(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return LikesKt.toProfiles((List)this.gatewayService.getLikers(postId));
    }

    @NotNull
    public List<Profile> getCommentLikers(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return LikesKt.toProfiles((List)this.gatewayService.getLikers(commentId));
    }

    @NotNull
    public PostTranslation translatePost(@NotNull String postId, @NotNull PostContent content, @NotNull String targetLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        return PostTranslation.Companion.toPostTranslation(this.gatewayService.translatePost(postId, content, targetLanguage));
    }

    private Comment getComment(String postId, String commentId) {
        Object v0;
        block2: {
            Sequence $this$firstOrNull$iv = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.getComments(postId)), (Function1)((Function1)getComment.1.INSTANCE));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Comment it = (Comment)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)commentId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Comment comment = v0;
        if (comment == null) {
            throw new NotFoundException("Comment with id " + commentId + " does not exist for post " + postId + ".");
        }
        return comment;
    }

    private <T> T withConfig(Function1<? super ConfigFragment, ? extends T> block) {
        return (T)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    public static final /* synthetic */ NewsApiGatewayService access$getGatewayService$p(NewsService $this) {
        return $this.gatewayService;
    }
}

