/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.google.common.base.MoreObjects;
import com.unboundid.scim2.common.types.UserResource;
import de.justsoftware.justimport.business.model.ToroProfile;
import de.justsoftware.justimport.domain.model.common.AbstractId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.kafka.model.KafkaProfile;
import de.justsoftware.justimport.persistence.model.DbAuditModel;
import de.justsoftware.justimport.persistence.model.DbProfileBuilder;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="Profile")
@ParametersAreNonnullByDefault
@EntityListeners(value={AuditingEntityListener.class})
public class DbProfile
extends DbAuditModel {
    @Column(nullable=false)
    private Long id;
    @Id
    private UUID uuid;
    @Column
    private UUID tenantId;
    @Column(nullable=false)
    private String email;
    @Column(nullable=false)
    private String fullName;
    @Column(nullable=false)
    private String firstName;
    @Column(nullable=false)
    private String lastName;
    @Column
    private String honorificPrefix;
    @Column
    private String honorificSuffix;
    @Column
    private String profileUrl;
    @Column
    private String imageUrl;
    @Column(nullable=false)
    private boolean active;
    @Column(nullable=false)
    private boolean blocked;
    @Column(nullable=false)
    private boolean deleted;
    @Column
    private Instant importedAt;
    @Column
    private ImportMethod importMethod;

    public DbProfile() {
    }

    public DbProfile(Long id, UUID uuid, UUID tenantId, String email, String fullName, String firstName, String lastName, @Nullable String honorificPrefix, @Nullable String honorificSuffix, @Nullable String profileUrl, @Nullable String imageUrl, boolean active, boolean blocked, boolean deleted, @Nullable Instant importedAt, @Nullable ImportMethod importMethod) {
        this.id = id;
        this.uuid = uuid;
        this.tenantId = tenantId;
        this.email = email;
        this.fullName = fullName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.honorificPrefix = honorificPrefix;
        this.honorificSuffix = honorificSuffix;
        this.profileUrl = profileUrl;
        this.imageUrl = imageUrl;
        this.active = active;
        this.blocked = blocked;
        this.deleted = deleted;
        this.importedAt = importedAt;
        this.importMethod = importMethod;
    }

    @Nonnull
    public static DbProfile fromKafka(KafkaProfile kafkaProfile) {
        UUID uuid = kafkaProfile.uid();
        if (uuid == null) {
            throw new IllegalStateException("uuid is required");
        }
        UUID tenantId = kafkaProfile.tenantId() == null ? null : (UUID)kafkaProfile.tenantId().getId();
        String email = kafkaProfile.email();
        if (email == null) {
            throw new IllegalStateException("email is required");
        }
        return new DbProfileBuilder().setId(kafkaProfile.id()).setUuid(uuid).setTenantId(tenantId).setEmail(email).setFullName(kafkaProfile.fullName()).setFirstName(kafkaProfile.firstName()).setLastName(kafkaProfile.lastName()).setProfileUrl(kafkaProfile.profileHash()).setImageUrl(DbProfile.imageUrlOrDefault((String)kafkaProfile.imageUrl())).setActive(kafkaProfile.active()).setBlocked(kafkaProfile.blocked()).setDeleted(kafkaProfile.deleted()).setImportedAt(null).setImportMethod(null).build();
    }

    public void updateFromKafka(KafkaProfile profile) {
        this.id = ProfileId.longId((AbstractId)profile.id());
        UUID uUID = this.tenantId = profile.tenantId() == null ? null : (UUID)profile.tenantId().getId();
        if (profile.email() != null) {
            this.email = profile.email();
        }
        this.firstName = profile.firstName();
        this.lastName = profile.lastName();
        this.fullName = profile.fullName();
        this.profileUrl = profile.profileHash();
        this.imageUrl = DbProfile.imageUrlOrDefault((String)profile.imageUrl());
        this.blocked = profile.blocked();
        this.active = profile.active();
        this.deleted = profile.deleted();
    }

    @Nonnull
    public Long getId() {
        return this.id;
    }

    @Nonnull
    public ProfileId getProfileId() {
        return ProfileId.fromLongId((Long)this.id);
    }

    @Nonnull
    public UUID getUuid() {
        return this.uuid;
    }

    @CheckForNull
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Nonnull
    public String getEmail() {
        return this.email;
    }

    @Nonnull
    public String getFullName() {
        return this.fullName;
    }

    @Nonnull
    public String getFirstName() {
        return this.firstName;
    }

    @Nonnull
    public String getLastName() {
        return this.lastName;
    }

    @CheckForNull
    public String getHonorificPrefix() {
        return this.honorificPrefix;
    }

    @CheckForNull
    public String getHonorificSuffix() {
        return this.honorificSuffix;
    }

    @CheckForNull
    public String getProfileUrl() {
        return this.profileUrl;
    }

    @Nonnull
    public String getImageUrl() {
        return this.imageUrl;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @CheckForNull
    public Instant getImportedAt() {
        return this.importedAt;
    }

    @CheckForNull
    public ImportMethod getImportMethod() {
        return this.importMethod;
    }

    @Nonnull
    public static DbProfile toDbProfile(Long id, UUID uuid, UserResource user) {
        String email = user.getUserName();
        String firstName = user.getName().getGivenName();
        String lastName = user.getName().getFamilyName();
        return new DbProfileBuilder().setId(id).setUuid(uuid).setEmail(email).setFirstName(firstName).setLastName(lastName).setHonorificPrefix(user.getName().getHonorificPrefix()).setHonorificSuffix(user.getName().getHonorificSuffix()).setActive(Boolean.TRUE.equals(user.getActive())).setImportedAt(Instant.now()).setImportMethod(ImportMethod.SCIM).build();
    }

    @Nonnull
    public static DbProfile toDbProfile(ToroProfile profile) {
        return new DbProfileBuilder().setId(profile.id()).setUuid(profile.uid()).setTenantId((UUID)profile.tenantId().getId()).setEmail(profile.email()).setFirstName(profile.firstName()).setLastName(profile.lastName()).setHonorificPrefix(profile.honorificPrefix()).setHonorificSuffix(profile.honorificSuffix()).setActive(Boolean.TRUE.equals(profile.active())).setImportedAt(Instant.now()).setImportMethod(ImportMethod.SCIM).build();
    }

    @Nonnull
    private static String imageUrlOrDefault(@Nullable String imageUrl) {
        String defaultAvatar = "/storageserver/images/original/user/default.png?v=10";
        return imageUrl == null ? "/storageserver/images/original/user/default.png?v=10" : imageUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbProfile that = (DbProfile)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.email, that.email) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.lastName, that.lastName) && Objects.equals(this.honorificPrefix, that.honorificPrefix) && Objects.equals(this.honorificSuffix, that.honorificSuffix) && Objects.equals(this.profileUrl, that.profileUrl) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.active, that.active) && Objects.equals(this.blocked, that.blocked) && Objects.equals(this.deleted, that.deleted) && Objects.equals(this.importedAt, that.importedAt) && Objects.equals(this.importMethod, that.importMethod);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uuid, this.tenantId, this.email, this.fullName, this.firstName, this.lastName, this.honorificPrefix, this.honorificSuffix, this.profileUrl, this.imageUrl, this.active, this.blocked, this.deleted, this.importedAt, this.importMethod);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("uuid", (Object)this.uuid).add("tenantId", (Object)this.tenantId).add("email", (Object)this.email).add("fullName", (Object)this.fullName).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("honorificPrefix", (Object)this.honorificPrefix).add("honorificSuffix", (Object)this.honorificSuffix).add("profileUrl", (Object)this.profileUrl).add("imageUrl", (Object)this.imageUrl).add("active", this.active).add("blocked", this.blocked).add("deleted", this.deleted).add("importedAt", (Object)this.importedAt).add("importMethod", (Object)this.importMethod).toString();
    }
}

