/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.kafka;

import de.justsoftware.justimport.kafka.model.KafkaProfile;
import de.justsoftware.justimport.persistence.ProfileRepository;
import de.justsoftware.justimport.persistence.ScimUserResourceRepository;
import de.justsoftware.justimport.persistence.model.DbProfile;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ProfileConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileConsumer.class);
    private static final String PROFILE_TOPIC = "just.persons";
    private final ProfileRepository _profileRepository;
    private final ScimUserResourceRepository _scimUserResourceRepository;

    @Autowired
    public ProfileConsumer(ProfileRepository profileRepository, ScimUserResourceRepository scimUserResourceRepository) {
        this._profileRepository = profileRepository;
        this._scimUserResourceRepository = scimUserResourceRepository;
    }

    @KafkaListener(topics={"just.persons"}, containerFactory="profileListenerContainerFactory", id="profileConsumer", idIsGroup=false)
    public void listen(ConsumerRecords<String, KafkaProfile> records) {
        records.forEach(record -> {
            try {
                if (record.value() == null || ((KafkaProfile)record.value()).deleted()) {
                    Long id = Long.parseLong((String)record.key());
                    Optional profile = this._profileRepository.findById(id);
                    if (profile.isEmpty()) {
                        return;
                    }
                    this._profileRepository.deleteById(id);
                    UUID tenantUid = ((DbProfile)profile.get()).getTenantId();
                    if (tenantUid != null) {
                        this._scimUserResourceRepository.deleteByProfileIdAndTenantId(((DbProfile)profile.get()).getUuid(), tenantUid);
                    }
                    LOG.info("User with id = {} was deleted from DB", (Object)id);
                    return;
                }
                if (((KafkaProfile)record.value()).tenantId() == null) {
                    LOG.error("User with id = {} had no associated tenantId. Record ignored.", (Object)((KafkaProfile)record.value()).id());
                    return;
                }
                UUID uid = ((KafkaProfile)record.value()).uid();
                if (uid == null) {
                    return;
                }
                String email = ((KafkaProfile)record.value()).email();
                if (email == null) {
                    return;
                }
                Optional maybeProfile = this._profileRepository.findById((Object)uid);
                if (maybeProfile.isEmpty()) {
                    return;
                }
                DbProfile profile = (DbProfile)maybeProfile.get();
                profile.updateFromKafka((KafkaProfile)record.value());
                this._profileRepository.save((Object)profile);
                LOG.info("User with id = {} was saved/updated", (Object)profile.getUuid());
            }
            catch (RuntimeException exception) {
                LOG.error("Failed to save or update profile with id = {}", (Object)((KafkaProfile)record.value()).id(), (Object)exception);
            }
        });
    }
}

