/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka.tenant;

import de.justsoftware.gateway.domain.tracking.TrackingSettingsService;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.kafka.tenant.TenantDto;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TenantConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(TenantConsumer.class);
    private static final String TENANT_TOPIC = "just.tenants";
    private final TrackingSettingsService _trackingSettingsService;

    public TenantConsumer(TrackingSettingsService trackingSettingsService) {
        this._trackingSettingsService = trackingSettingsService;
    }

    @KafkaListener(topics={"just.tenants"}, containerFactory="tenantListenerContainerFactory")
    public void listen(ConsumerRecords<TenantId, TenantDto> records) {
        HashMap<TenantId, TenantDto> values = new HashMap<TenantId, TenantDto>();
        records.forEach(record -> values.put((TenantId)record.key(), (TenantDto)record.value()));
        LOG.debug("fetched {} records", (Object)records.count());
        values.forEach((tenantId, tenantDto) -> {
            LOG.debug("tenantId: {}, tenantDTO: {}", tenantId, tenantDto);
            if (tenantDto == null || tenantDto.getTrackingSettingsDto() == null) {
                this._trackingSettingsService.deleteSettingsById(tenantId);
            } else {
                this._trackingSettingsService.upsertSettings(tenantId, tenantDto.getTrackingSettingsDto()).subscribe();
            }
        });
        LOG.debug("processing done");
    }
}

