/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.config;

import de.justsoftware.gateway.kafka.ClientRegistrationDeserializer;
import de.justsoftware.gateway.kafka.ExternalIdMappingDeserializer;
import de.justsoftware.gateway.kafka.JustPersonDto;
import de.justsoftware.gateway.kafka.ProfileIdDeserializer;
import de.justsoftware.gateway.kafka.tenant.TenantDto;
import de.justsoftware.gateway.kafka.tenant.TenantIdDeserializer;
import de.justsoftware.gateway.kafka.tracking.TrackingValue;
import de.justsoftware.generated.proto.ClientRegistration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.CommonLoggingErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.kafka.support.serializer.JsonDeserializer;

@Configuration
@EnableKafka
@ParametersAreNonnullByDefault
public class KafkaConsumerConfiguration {
    public static final String EARLIEST = "earliest";
    private final String _bootstrapServers;
    private final String _hostname;

    @Autowired
    public KafkaConsumerConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") String bootstrapServers, @Value(value="${system.hostname}") String hostname) {
        this._bootstrapServers = bootstrapServers;
        this._hostname = hostname;
    }

    @Nonnull
    private HashMap<String, Object> newConsumerFactoryPropsWithDefaults() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("auto.offset.reset", EARLIEST);
        props.put("key.deserializer", ErrorHandlingDeserializer.class);
        props.put("value.deserializer", ErrorHandlingDeserializer.class);
        return props;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, ClientRegistration>> registrationListenerContainerFactory() {
        HashMap props = this.newConsumerFactoryPropsWithDefaults();
        props.put("enable.auto.commit", "false");
        props.put("group.id", "just.gateway.oauthClientRegistrationConsumer_" + this._hostname);
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", ClientRegistrationDeserializer.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new CommonLoggingErrorHandler());
        return factory;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> externalIdListenerContainerFactory() {
        HashMap props = this.newConsumerFactoryPropsWithDefaults();
        props.put("group.id", "just.gateway.externalIdConsumer_" + this._hostname);
        props.put("spring.deserializer.key.delegate.class", ProfileIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", ExternalIdMappingDeserializer.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new CommonLoggingErrorHandler());
        return factory;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> justPersonsContainerFactory() {
        HashMap props = this.newConsumerFactoryPropsWithDefaults();
        props.put("group.id", "just.gateway.personsConsumer_" + this._hostname);
        props.put("spring.deserializer.key.delegate.class", ProfileIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", JsonDeserializer.class);
        props.put("spring.json.value.default.type", JustPersonDto.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new CommonLoggingErrorHandler());
        return factory;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> tenantListenerContainerFactory() {
        HashMap props = this.newConsumerFactoryPropsWithDefaults();
        props.put("group.id", "just.gateway.tenantConsumer");
        props.put("auto.offset.reset", EARLIEST);
        props.put("spring.deserializer.key.delegate.class", TenantIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", JsonDeserializer.class);
        props.put("spring.json.value.default.type", TenantDto.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler());
        factory.setBatchListener(Boolean.valueOf(true));
        return factory;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> mobileTrackingListenerContainerFactory() {
        HashMap props = this.newConsumerFactoryPropsWithDefaults();
        props.put("group.id", "just.gateway.mobileTrackingConsumer");
        props.put("auto.offset.reset", EARLIEST);
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", JsonDeserializer.class);
        props.put("spring.json.value.default.type", TrackingValue.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new CommonLoggingErrorHandler());
        factory.setBatchListener(Boolean.valueOf(true));
        return factory;
    }
}

