/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.tasks.processes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.jdoc.services.tasks.processes.NativeProcessManager;
import de.justsoftware.jdoc.services.tasks.processes.ProcessWatchdogService;
import de.justsoftware.jdoc.services.tasks.processes.model.CommandlineCallToWatch;
import de.justsoftware.jdoc.services.tasks.processes.model.NativeProcessData;
import de.justsoftware.jdoc.services.tasks.processes.model.NativeProcessId;
import de.justsoftware.jdoc.services.tasks.processes.model.ProcessToWatch;
import de.justsoftware.jdoc.services.tasks.processes.model.WatchedProcessId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.exec.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Service;

@Service(value="processWatchdogService")
@ParametersAreNonnullByDefault
public class ProcessWatchdogServiceImpl
implements ProcessWatchdogService,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWatchdogServiceImpl.class);
    private final ConcurrentHashMap<NativeProcessId, ProcessToWatch> _nativeProcessMap;
    private final ConcurrentHashMap<WatchedProcessId, CommandlineCallToWatch> _watchedCommandMap;
    private final NativeProcessManager _nativeProcessManager;
    private final ProcessWatchdogService.SurvivorFunction _survivorFunction;

    @Autowired
    public ProcessWatchdogServiceImpl(NativeProcessManager nativeProcessManager) {
        this(nativeProcessManager, ProcessWatchdogServiceImpl::isSurviverOrTimedOut, new ConcurrentHashMap(), new ConcurrentHashMap());
    }

    @VisibleForTesting
    public ProcessWatchdogServiceImpl(NativeProcessManager nativeProcessManager, ProcessWatchdogService.SurvivorFunction survivorFunction, ConcurrentHashMap<NativeProcessId, ProcessToWatch> nativeProcessMap, ConcurrentHashMap<WatchedProcessId, CommandlineCallToWatch> watchedCommandMap) {
        this._nativeProcessManager = nativeProcessManager;
        this._survivorFunction = survivorFunction;
        this._nativeProcessMap = nativeProcessMap;
        this._watchedCommandMap = watchedCommandMap;
    }

    private static boolean isSurviverOrTimedOut(long timestamp, CommandlineCallToWatch pct) {
        return timestamp > pct.getCreationDate() + pct.getMaxRuntimeInMillis() || pct.isSurvivor();
    }

    public void checkProcesses() {
        if (!this._nativeProcessMap.isEmpty() || !this._watchedCommandMap.isEmpty()) {
            long timestamp = System.currentTimeMillis();
            List processList = this._nativeProcessManager.getProcessList();
            HashMultimap parentChildProcessIdMap = HashMultimap.create();
            HashMap unassignedProcessMap = Maps.newHashMap();
            HashSet activePids = Sets.newHashSet();
            for (NativeProcessData proc : processList) {
                if (!this._nativeProcessMap.containsKey(proc.getPid())) {
                    unassignedProcessMap.put(proc.getPid(), proc);
                }
                activePids.add(proc.getPid());
                parentChildProcessIdMap.put((Object)proc.getParentPid(), (Object)proc.getPid());
            }
            this.assignUnassignedProcesses(timestamp, (Map)unassignedProcessMap);
            this.cleanupDuplicates((Map)unassignedProcessMap);
            this.logStatus();
            this.cleanup(timestamp, (Set)activePids, this.getActiveParentChildMap((Set)activePids, (SetMultimap)parentChildProcessIdMap));
        }
    }

    @Nonnull
    private SetMultimap<NativeProcessId, NativeProcessId> getActiveParentChildMap(Set<NativeProcessId> activePids, SetMultimap<NativeProcessId, NativeProcessId> flatParentChildMap) {
        ImmutableSetMultimap.Builder resultBuilder = ImmutableSetMultimap.builder();
        for (NativeProcessId pid : activePids) {
            int size;
            HashSet allChildren = Sets.newHashSet();
            Set children = flatParentChildMap.get((Object)pid);
            do {
                size = allChildren.size();
                Set childrenToCheck = children;
                children = Sets.newHashSet((Iterable)childrenToCheck);
                for (NativeProcessId childPid : childrenToCheck) {
                    children.addAll(flatParentChildMap.get((Object)childPid));
                }
                allChildren.addAll(children);
            } while (size < allChildren.size());
            resultBuilder.putAll((Object)pid, (Iterable)allChildren);
        }
        return resultBuilder.build();
    }

    private void cleanupDuplicates(Map<NativeProcessId, NativeProcessData> unassignedProcessMap) {
        ArrayList<ProcessToWatch> doubles = new ArrayList<ProcessToWatch>();
        for (Map.Entry<NativeProcessId, NativeProcessData> newProc : unassignedProcessMap.entrySet()) {
            for (Map.Entry currentProc : this._nativeProcessMap.entrySet()) {
                if (!this.matches(((ProcessToWatch)currentProc.getValue()).getSpecification(), newProc.getValue())) continue;
                doubles.add(new ProcessToWatch(newProc.getValue(), ((ProcessToWatch)currentProc.getValue()).getSpecification()));
            }
        }
        for (ProcessToWatch pct : doubles) {
            unassignedProcessMap.remove(pct.getPid());
            this._nativeProcessMap.put(pct.getPid(), pct);
        }
    }

    private void assignUnassignedProcesses(long timestamp, Map<NativeProcessId, NativeProcessData> unassignedProcessMap) {
        HashSet assignedIds = Sets.newHashSet();
        for (Map.Entry newProc : this._watchedCommandMap.entrySet()) {
            ProcessToWatch ptw = null;
            for (Map.Entry<NativeProcessId, NativeProcessData> foundProc : unassignedProcessMap.entrySet()) {
                if (!this.matches((CommandlineCallToWatch)newProc.getValue(), foundProc.getValue())) continue;
                ptw = new ProcessToWatch(foundProc.getValue(), (CommandlineCallToWatch)newProc.getValue());
                break;
            }
            if (ptw != null) {
                unassignedProcessMap.remove(ptw.getPid());
                assignedIds.add(ptw.getId());
                for (ProcessToWatch pct : this._nativeProcessMap.values()) {
                    if (!pct.getFullCommand().equals(ptw.getFullCommand())) continue;
                    pct.markAsSurvivor();
                }
                this._nativeProcessMap.put(ptw.getPid(), ptw);
                LOG.debug("added new process to watch: " + ((CommandlineCallToWatch)newProc.getValue()).toString());
                continue;
            }
            if (!this._survivorFunction.isSurvivor(timestamp, (CommandlineCallToWatch)newProc.getValue())) continue;
            assignedIds.add(((CommandlineCallToWatch)newProc.getValue()).getId());
        }
        for (WatchedProcessId id : assignedIds) {
            this._watchedCommandMap.remove(id);
        }
    }

    private boolean matches(CommandlineCallToWatch procToFind, NativeProcessData procFound) {
        ImmutableSet identifiers = procToFind.getIdentifiers();
        if (identifiers.isEmpty()) {
            return false;
        }
        String fc = procFound.getFullCommand();
        for (String identifier : identifiers) {
            if (fc.contains(identifier.trim())) continue;
            return false;
        }
        return true;
    }

    private void cleanup(long timestamp, Set<NativeProcessId> activePids, SetMultimap<NativeProcessId, NativeProcessId> parentChildMap) {
        HashSet removedPids = Sets.newHashSet((Iterable)this._nativeProcessMap.keySet());
        removedPids.removeAll(activePids);
        ArrayList<NativeProcessId> killed = new ArrayList<NativeProcessId>();
        for (ProcessToWatch pct : this._nativeProcessMap.values()) {
            NativeProcessId pid = pct.getPid();
            if (removedPids.contains(pid)) {
                killed.add(pid);
                LOG.debug("removed process to watch : " + pct);
                continue;
            }
            if (!this._survivorFunction.isSurvivor(timestamp, pct.getSpecification()) || !this._nativeProcessManager.killProcess(pid, ImmutableSet.copyOf((Collection)parentChildMap.get((Object)pid)))) continue;
            killed.add(pid);
            LOG.debug("killed process and removed from watch : " + pct);
        }
        for (NativeProcessId key : killed) {
            this._nativeProcessMap.remove(key);
        }
    }

    private void logStatus() {
        if (this._watchedCommandMap.size() + this._nativeProcessMap.size() > 0) {
            LOG.debug("status count of [unassigned,watched] processes : [{}, {}]", (Object)this._watchedCommandMap.size(), (Object)this._nativeProcessMap.size());
        }
    }

    public WatchedProcessId addProcessToWatch(CommandLine command, long maxTimeToLive) {
        CommandlineCallToWatch processToWatch = new CommandlineCallToWatch(new WatchedProcessId(), ImmutableSet.builder().add((Object)command.getExecutable()).addAll((Iterable)ImmutableList.copyOf((Object[])command.getArguments())).build(), maxTimeToLive);
        this._watchedCommandMap.put(processToWatch.getId(), processToWatch);
        LOG.debug("added process to watch: " + processToWatch);
        return processToWatch.getId();
    }

    public boolean killAllWatchedProcesses() {
        for (ProcessToWatch pct : this._nativeProcessMap.values()) {
            pct.markAsSurvivor();
        }
        for (ProcessToWatch pct : this._watchedCommandMap.values()) {
            pct.markAsSurvivor();
        }
        this.checkProcesses();
        return this._nativeProcessMap.isEmpty() && this._watchedCommandMap.isEmpty();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        LOG.info("Received shutdown signal. Attempt to kill all watched processes. This can take up to 5s.");
        try {
            for (int retry = 0; !this.killAllWatchedProcesses() && retry < 100; ++retry) {
                this.wait(50L);
            }
            LOG.info("Killed all watched processes.");
        }
        catch (InterruptedException e) {
            LOG.error("Got interrupted! Some processes may survive this shutdown!");
        }
    }

    public void removeProcessFromWatch(WatchedProcessId watchedId) {
        CommandlineCallToWatch ccw = (CommandlineCallToWatch)this._watchedCommandMap.get(watchedId);
        if (ccw != null) {
            ccw.markAsSurvivor();
        }
        for (ProcessToWatch pct : this._nativeProcessMap.values()) {
            if (!watchedId.equals((Object)pct.getId())) continue;
            pct.markAsSurvivor();
        }
    }
}

