/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionRequest;
import de.justsoftware.jdoc.rest.model.ExternalDocumentType;
import de.justsoftware.jdoc.services.exceptions.DirectoryCreateFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class TempFileService
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFileService.class);
    private final String _tempDirectoryPath;
    private final String _conversionSourceDirectoryPath;

    public TempFileService(@Value(value="${judo.tmpDir}") String tempDirectoryPath, @Value(value="${judo.storage.repositoryPath}") String conversionSourceDirectoryPath) {
        this._tempDirectoryPath = tempDirectoryPath;
        this._conversionSourceDirectoryPath = conversionSourceDirectoryPath;
    }

    @Nonnull
    public File createTempDirectory() throws DirectoryCreateFailedException {
        Path tempDir = Paths.get(this._tempDirectoryPath, "jdoc", new SimpleDateFormat("yyyy-MM-dd").format(new Date()), UUID.randomUUID().toString());
        try {
            return Files.createDirectories(tempDir, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new DirectoryCreateFailedException("can't create temporary folder " + tempDir.toAbsolutePath());
        }
    }

    public void cleanupTempDirectory(@Nullable File tempDir) {
        block3: {
            if (tempDir != null && tempDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)tempDir);
                }
                catch (IOException e) {
                    if (FileUtils.deleteQuietly((File)tempDir)) break block3;
                    tempDir.deleteOnExit();
                }
            }
        }
    }

    @Nonnull
    public DocumentStatus cleanUpSource(ConversionRequest request) {
        DocumentId documentId = request.getDocumentId();
        LOGGER.info("Cleaning up originals for document {}", (Object)documentId);
        DocumentType targetType = request.getTargetType();
        File originalDir = new File(String.format("%s/%s/%s", this._conversionSourceDirectoryPath, documentId, DocumentType.ORIGINAL));
        File pdfDir = new File(String.format("%s/%s/%s", this._conversionSourceDirectoryPath, documentId, DocumentType.PDF));
        try {
            if (targetType.equals((Object)DocumentType.PDF)) {
                FileUtils.deleteDirectory((File)originalDir);
                LOGGER.info("Deleted original in {}", (Object)originalDir);
                return DocumentStatus.CLEANED_UP;
            }
            if (targetType.equals((Object)DocumentType.HTML)) {
                FileUtils.deleteDirectory((File)pdfDir);
                LOGGER.info("Deleted PDF in {}", (Object)pdfDir);
                return DocumentStatus.CLEANED_UP;
            }
            return DocumentStatus.PRESENT;
        }
        catch (IOException e) {
            return DocumentStatus.ERROR;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Path path = Paths.get(this._tempDirectoryPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.info("tmp directory does not exist, trying to create: {}", (Object)path.toString());
            Files.createDirectories(path, new FileAttribute[0]);
            LOGGER.info("creation successfull");
        }
    }

    public void cleanUpAllSources() {
        Path startPath = Paths.get(this._conversionSourceDirectoryPath, new String[0]);
        try (Stream<Path> paths = Files.walk(startPath, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> Optional.ofNullable(path).map(Path::getParent).filter(parentPath -> parentPath.endsWith(ExternalDocumentType.ORIGINAL.toString()) || parentPath.endsWith(ExternalDocumentType.PDF.toString())).ifPresent(parentPath -> {
                Path fileNamePath = path.getFileName();
                if (fileNamePath != null) {
                    String fileName = fileNamePath.toString();
                    if (fileName.equals(DocumentStatus.PRESENT.toString())) {
                        try {
                            Files.move(path, path.resolveSibling(DocumentStatus.CLEANED_UP.toString()), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            LOGGER.error("Could not move file {}.", path);
                        }
                    } else {
                        try {
                            if (Files.deleteIfExists(path)) {
                                Files.deleteIfExists(parentPath);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Could not delete file or parent directory for {}.", path);
                        }
                    }
                }
            }));
        }
        catch (IOException e) {
            LOGGER.error("Could not delete all preview sources.");
        }
    }
}

