/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;

@ParametersAreNonnullByDefault
@Configuration
@Profile(value={"!test"})
public class KafkaTopicConfig {
    private static final String ONE_DAY_IN_MS = "86400000";

    @Bean
    @Nonnull
    public KafkaAdmin admin(@Value(value="${kafka.bootstrapServers}") String bootstrapServer) {
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }

    @Nonnull
    @Bean
    public NewTopic browserPushDispatchTopic() {
        NewTopic topic = new NewTopic("just.browserpush.dispatch", 1, 1);
        return topic.configs((Map)ImmutableMap.of((Object)"delete.retention.ms", (Object)ONE_DAY_IN_MS, (Object)"segment.ms", (Object)ONE_DAY_IN_MS, (Object)"cleanup.policy", (Object)"delete"));
    }
}

