/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.ScimConfigApplicationService;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.toro.ToroConnector;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.ApiToken;
import de.justsoftware.admin.graphql.generated.types.ScimFieldMappingEntry;
import de.justsoftware.admin.graphql.generated.types.ScimFieldMappingEntryInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.id.TenantId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0017J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0017J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/ScimConfigFetcher;", "", "toroConnector", "Lde/justsoftware/admin/connector/toro/ToroConnector;", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "scimConfigApplicationService", "Lde/justsoftware/admin/application/web/ScimConfigApplicationService;", "(Lde/justsoftware/admin/connector/toro/ToroConnector;Lde/justsoftware/admin/application/web/TenantApplicationService;Lde/justsoftware/admin/application/web/ScimConfigApplicationService;)V", "availableConfigFields", "", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "deleteToken", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "generateToken", "replaceAvailableScimFields", "input", "replaceScimFieldMapping", "Lde/justsoftware/admin/graphql/generated/types/ScimFieldMappingEntryInput;", "scimFieldMapping", "Lde/justsoftware/admin/graphql/generated/types/ScimFieldMappingEntry;", "setAvailableScimFieldsToDefault", "token", "Lde/justsoftware/admin/graphql/generated/types/ApiToken;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nScimConfigFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScimConfigFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/ScimConfigFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1855#2:109\n1855#2,2:110\n1856#2:112\n1855#2,2:113\n*S KotlinDebug\n*F\n+ 1 ScimConfigFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/ScimConfigFetcher\n*L\n48#1:109\n49#1:110,2\n48#1:112\n63#1:113,2\n*E\n"})
public class ScimConfigFetcher {
    @NotNull
    private final ToroConnector toroConnector;
    @NotNull
    private final TenantApplicationService tenantApplicationService;
    @NotNull
    private final ScimConfigApplicationService scimConfigApplicationService;

    public ScimConfigFetcher(@NotNull ToroConnector toroConnector, @NotNull TenantApplicationService tenantApplicationService, @NotNull ScimConfigApplicationService scimConfigApplicationService) {
        Intrinsics.checkNotNullParameter((Object)toroConnector, (String)"toroConnector");
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        Intrinsics.checkNotNullParameter((Object)scimConfigApplicationService, (String)"scimConfigApplicationService");
        this.toroConnector = toroConnector;
        this.tenantApplicationService = tenantApplicationService;
        this.scimConfigApplicationService = scimConfigApplicationService;
    }

    @DgsData(parentType="Tenant", field="scimToken")
    @Nullable
    public ApiToken token(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        return this.toroConnector.getScimToken(tenantId);
    }

    @DgsData(parentType="Tenant", field="scimAvailableConfigFields")
    @NotNull
    public List<String> availableConfigFields(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return CollectionsKt.toList((Iterable)this.scimConfigApplicationService.getAllScimFields(authContext));
    }

    @DgsData(parentType="Tenant", field="scimFieldMapping")
    @NotNull
    public List<ScimFieldMappingEntry> scimFieldMapping(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        Map mapping = this.toroConnector.getFieldMapping(authContext.getNonNullTenantId());
        List output = new ArrayList();
        Iterable $this$forEach$iv = mapping.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)entry.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                output.add(new ScimFieldMappingEntry((Function0)new /* Unavailable Anonymous Inner Class!! */, (Function0)new /* Unavailable Anonymous Inner Class!! */));
            }
        }
        return output;
    }

    @DgsMutation(field="replaceScimFieldMapping")
    @NotNull
    public Tenant replaceScimFieldMapping(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull List<ScimFieldMappingEntryInput> input) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        Map mapping = new LinkedHashMap();
        Iterable $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScimFieldMappingEntryInput it = (ScimFieldMappingEntryInput)element$iv;
            boolean bl = false;
            String key = it.getSourceAttribute();
            Set updatedSet = SetsKt.plus((Set)mapping.getOrDefault(key, SetsKt.emptySet()), (Object)it.getJustAttribute());
            mapping.put(key, updatedSet);
        }
        this.toroConnector.replaceFieldMapping(mapping, authContext.getNonNullTenantId());
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="replaceAvailableScimFields")
    @NotNull
    public Tenant replaceAvailableScimFields(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull List<String> input) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.scimConfigApplicationService.replaceAllScimFields((Collection)input, authContext);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="setAvailableScimFieldsToDefault")
    @NotNull
    public Tenant setAvailableScimFieldsToDefault(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.scimConfigApplicationService.setScimFieldsToDefault(authContext);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="generateScimToken")
    @NotNull
    public Tenant generateToken(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.toroConnector.generateScimToken(tenantId);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="deleteScimToken")
    @NotNull
    public Tenant deleteToken(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.toroConnector.deleteScimToken(tenantId);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }
}

