/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.config.ZookeeperConfig;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.appsettings.model.AppHomeScreenPosition;
import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.AppPlacementType;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppPlacement;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.id.CoreAppId;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ExternalAppId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.mybatis.mapper.AppHomeScreenPositionMapper;
import de.justsoftware.admin.mybatis.mapper.AppPlacementMapper;
import de.justsoftware.admin.mybatis.mapper.CoreAppSettingsMapper;
import de.justsoftware.admin.mybatis.mapper.ExternalAppSettingsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u00100\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001902012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00103\u001a\u00020\u00122\u0006\u0010-\u001a\u000204H\u0016J\u0018\u00103\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u0012022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00107\u001a\u00020\u001f2\u0006\u0010-\u001a\u000208H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0019022\u0006\u0010=\u001a\u00020.H\u0016J\u001e\u0010>\u001a\u00020\u001d2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020.0\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J1\u0010@\u001a\u00020\u001d2\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0012\u00a2\u0006\u0002\u0010FJ}\u0010G\u001a\u00020\u00122\u0006\u0010-\u001a\u0002042\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010D2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010J2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010J2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D2\u0010\b\u0002\u0010L\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0010\b\u0002\u0010M\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010NJ\u0093\u0001\u0010O\u001a\u00020\u001f2\u0006\u0010-\u001a\u0002082\u0006\u0010\"\u001a\u00020#2\b\u0010H\u001a\u0004\u0018\u00010D2\u000e\u0010P\u001a\n\u0012\u0004\u0012\u00020Q\u0018\u00010!2\b\u0010K\u001a\u0004\u0018\u00010J2\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010R\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010S2\b\u0010U\u001a\u0004\u0018\u00010V2\u000e\u0010L\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u000e\u0010M\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010WJ\u0010\u0010X\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020%H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "", "coreAppRepo", "Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;", "appHomeScreenPositionRepo", "Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;", "appPlacementRepo", "Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "externalAppSettingsRepo", "Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;", "zookeeperConfig", "Lde/justsoftware/admin/config/ZookeeperConfig;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "(Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;Lde/justsoftware/admin/config/ZookeeperConfig;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;)V", "createCoreApp", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "createDefaultAppPlacements", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "createExternalApp", "", "externalAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "placements", "", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "createInitialApps", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "deleteAppPlacements", "userId", "Lde/justsoftware/admin/id/UserId;", "deleteCoreApp", "coreApp", "deleteExternalApp", "getApp", "id", "Lde/justsoftware/admin/id/AppId;", "getAppsByTenant", "getAppsWithPlacements", "", "", "getCoreApp", "Lde/justsoftware/admin/id/CoreAppId;", "getCoreAppsByApp", "getCoreAppsByTenant", "getExternalApp", "Lde/justsoftware/admin/id/ExternalAppId;", "getExternalApps", "getLastPosition", "", "getPlacements", "appId", "saveAppPositions", "appIds", "syncIconChangesWithDrive", "iconId", "Lde/justsoftware/admin/id/DocumentId;", "removeIcon", "", "origin", "(Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Lde/justsoftware/admin/domain/appsettings/model/AppSettings;Lde/justsoftware/admin/id/ProfileId;)V", "updateCoreApp", "active", "appColor", "Lde/justsoftware/admin/model/HexColor;", "homeScreenAppColor", "placementAdds", "placementRemoves", "(Lde/justsoftware/admin/id/CoreAppId;Lde/justsoftware/admin/id/ProfileId;Ljava/lang/Boolean;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;)Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "updateExternalApp", "clients", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$Client;", "name", "", "url", "openUrlIn", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;", "(Lde/justsoftware/admin/id/ExternalAppId;Lde/justsoftware/admin/id/ProfileId;Ljava/lang/Boolean;Ljava/util/Collection;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;Ljava/util/List;Ljava/util/List;)Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "upsertAppPosition", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1549#2:351\n1620#2,3:352\n1549#2:355\n1620#2,3:356\n1855#2,2:359\n1855#2,2:362\n819#2:364\n847#2,2:365\n819#2:367\n847#2,2:368\n1549#2:370\n1620#2,3:371\n1549#2:374\n1620#2,3:375\n1549#2:378\n1620#2,3:379\n1855#2,2:382\n1855#2,2:384\n1855#2,2:386\n1855#2,2:388\n1045#2:390\n1549#2:391\n1620#2,3:392\n1559#2:395\n1590#2,4:396\n1855#2,2:400\n1045#2:402\n1271#2,2:403\n1285#2,4:405\n1045#2:409\n1045#2:410\n1#3:361\n*S KotlinDebug\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n*L\n54#1:351\n54#1:352,3\n64#1:355\n64#1:356,3\n74#1:359,2\n106#1:362,2\n124#1:364\n124#1:365,2\n125#1:367\n125#1:368,2\n126#1:370\n126#1:371,3\n127#1:374\n127#1:375,3\n138#1:378\n138#1:379,3\n172#1:382,2\n173#1:384,2\n213#1:386,2\n214#1:388,2\n234#1:390\n235#1:391\n235#1:392,3\n244#1:395\n244#1:396,4\n245#1:400,2\n274#1:402\n277#1:403,2\n277#1:405,4\n284#1:409\n292#1:410\n*E\n"})
public class AppSettingsService {
    @NotNull
    private final CoreAppSettingsMapper coreAppRepo;
    @NotNull
    private final AppHomeScreenPositionMapper appHomeScreenPositionRepo;
    @NotNull
    private final AppPlacementMapper appPlacementRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final ExternalAppSettingsMapper externalAppSettingsRepo;
    @NotNull
    private final ZookeeperConfig zookeeperConfig;
    @NotNull
    private final SuperopertyConnector superopertyConnector;

    public AppSettingsService(@NotNull CoreAppSettingsMapper coreAppRepo, @NotNull AppHomeScreenPositionMapper appHomeScreenPositionRepo, @NotNull AppPlacementMapper appPlacementRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull ExternalAppSettingsMapper externalAppSettingsRepo, @NotNull ZookeeperConfig zookeeperConfig, @NotNull SuperopertyConnector superopertyConnector) {
        Intrinsics.checkNotNullParameter((Object)coreAppRepo, (String)"coreAppRepo");
        Intrinsics.checkNotNullParameter((Object)appHomeScreenPositionRepo, (String)"appHomeScreenPositionRepo");
        Intrinsics.checkNotNullParameter((Object)appPlacementRepo, (String)"appPlacementRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)externalAppSettingsRepo, (String)"externalAppSettingsRepo");
        Intrinsics.checkNotNullParameter((Object)zookeeperConfig, (String)"zookeeperConfig");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        this.coreAppRepo = coreAppRepo;
        this.appHomeScreenPositionRepo = appHomeScreenPositionRepo;
        this.appPlacementRepo = appPlacementRepo;
        this.driveApiConnector = driveApiConnector;
        this.externalAppSettingsRepo = externalAppSettingsRepo;
        this.zookeeperConfig = zookeeperConfig;
        this.superopertyConnector = superopertyConnector;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppPlacement> createDefaultAppPlacements(@NotNull UserGroup userGroup) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        AppPlacementType appPlacementType;
        UserGroupId userGroupId;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        TenantId tenantId = userGroup.getTenantId();
        Iterable iterable = CoreAppPlacement.Companion.getAppsWithDefaultPlacements();
        boolean $i$f$map22 = false;
        void var6_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CoreAppId coreAppId = CoreAppId.Companion.fromAppAndTenantId((CoreApp)it, tenantId);
            userGroupId = userGroup.getId();
            appPlacementType = AppPlacementType.MANDATORY;
            collection.add(new CoreAppPlacement(coreAppId, (UserId)userGroupId, appPlacementType, tenantId));
        }
        List coreAppPlacements = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalAppSettings bl = (ExternalAppSettings)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            userGroupId = it.getId();
            appPlacementType = userGroup.getId();
            AppPlacementType appPlacementType2 = AppPlacementType.RECOMMENDED;
            collection.add(new AppPlacement((AppId)userGroupId, (UserId)appPlacementType, appPlacementType2, tenantId));
        }
        List externalAppPlacements = (List)destination$iv$iv2;
        List placements = CollectionsKt.plus((Collection)coreAppPlacements, (Iterable)externalAppPlacements);
        Iterable $this$forEach$iv = placements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        return placements;
    }

    @NotNull
    public CoreAppSettings createCoreApp(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        if (!(app == CoreApp.CONNECT || app == CoreApp.TASKS)) {
            boolean $i$a$-require-AppSettingsService$createCoreApp$22 = false;
            String $i$a$-require-AppSettingsService$createCoreApp$22 = app + " can't be created!";
            throw new IllegalArgumentException($i$a$-require-AppSettingsService$createCoreApp$22.toString());
        }
        CoreAppSettings appSettings = CoreAppSettings.Companion.withDefaults$default((CoreAppSettings.Companion)CoreAppSettings.Companion, (TenantId)tenantId, (CoreApp)app, (boolean)false, null, null, null, null, null, (int)this.getLastPosition(tenantId), (int)252, null);
        this.coreAppRepo.upsertCoreApp(appSettings);
        AppHomeScreenPosition position = new AppHomeScreenPosition((AppId)appSettings.getId(), appSettings.getPosition(), appSettings.getTenantId());
        this.appHomeScreenPositionRepo.upsert(position);
        return appSettings;
    }

    public void createExternalApp(@NotNull ExternalAppSettings externalAppSettings, @NotNull Collection<? extends AppPlacement> placements, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)externalAppSettings, (String)"externalAppSettings");
        Intrinsics.checkNotNullParameter(placements, (String)"placements");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.appHomeScreenPositionRepo.upsert(new AppHomeScreenPosition((AppId)externalAppSettings.getId(), externalAppSettings.getPosition(), externalAppSettings.getTenantId()));
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)placements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        DocumentId documentId = externalAppSettings.getIconId();
        if (documentId != null) {
            DocumentId it = documentId;
            boolean bl = false;
            this.driveApiConnector.addFile(it, externalAppSettings.getTenantId(), profileId);
        }
        this.externalAppSettingsRepo.upsert(externalAppSettings);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> createInitialApps(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        CoreApp it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$filterNot$iv = (Iterable)CoreApp.getEntries();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (CoreApp)element$iv$iv;
            boolean bl = false;
            if (!this.superopertyConnector.isTasksAppEnabled() && it == CoreApp.TASKS) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (CoreApp)element$iv$iv;
            boolean bl = false;
            if (!this.superopertyConnector.isConnectAppEnabled() && it == CoreApp.CONNECT) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CoreAppSettings.Companion.withDefaults$default((CoreAppSettings.Companion)CoreAppSettings.Companion, (TenantId)tenantId, (CoreApp)it, (boolean)false, null, null, null, null, null, (int)0, (int)508, null));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (CoreAppSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            this.coreAppRepo.upsertCoreApp((CoreAppSettings)it);
            this.upsertAppPosition((AppSettings)it);
            collection.add(it);
        }
        List coreApps = (List)destination$iv$iv;
        Object $i$f$map2 = new ExternalAppSettings[]{ExternalAppSettings.Companion.withDefaultsForMeetApp$default((ExternalAppSettings.Companion)ExternalAppSettings.Companion, (TenantId)tenantId, (String)this.zookeeperConfig.getHost(), (boolean)false, (int)0, (int)12, null), ExternalAppSettings.Companion.withDefaultsForSupportApp(tenantId), ExternalAppSettings.Companion.withDefaultsForWebsiteApp(tenantId)};
        $i$f$map2 = CollectionsKt.listOf((Object[])$i$f$map2);
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ExternalAppSettings bl = (ExternalAppSettings)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            this.externalAppSettingsRepo.upsert((ExternalAppSettings)it2);
            this.upsertAppPosition((AppSettings)it2);
            collection.add(it2);
        }
        List externalApps = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)coreApps, (Iterable)externalApps);
    }

    @NotNull
    public CoreAppSettings updateCoreApp(@NotNull CoreAppId id, @NotNull ProfileId profileId, @Nullable Boolean active, @Nullable HexColor appColor, @Nullable HexColor homeScreenAppColor, @Nullable DocumentId iconId, @Nullable Boolean removeIcon, @Nullable List<? extends AppPlacement> placementAdds, @Nullable List<? extends AppPlacement> placementRemoves) {
        AppPlacement it;
        Object object;
        Object object2;
        Object object3;
        HexColor hexColor;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        CoreAppSettings origin = this.getCoreApp(id);
        Boolean bl = active;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getActive();
        HexColor hexColor2 = appColor;
        if (hexColor2 == null) {
            hexColor2 = hexColor = origin.getAppColor();
        }
        if ((object3 = homeScreenAppColor) == null) {
            object3 = object2 = origin.getHomeScreenAppColor();
        }
        if ((object = iconId) == null) {
            object = Intrinsics.areEqual((Object)removeIcon, (Object)true) ? null : origin.getIconId();
        }
        DocumentId documentId = object;
        CoreAppSettings updated = CoreAppSettings.copy$default((CoreAppSettings)origin, null, (boolean)bl2, (DocumentId)documentId, null, null, null, (HexColor)hexColor, (HexColor)object2, (int)0, (int)313, null);
        List<? extends AppPlacement> list = placementRemoves;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl3 = false;
                this.appPlacementRepo.delete(it);
            }
        }
        List<? extends AppPlacement> list2 = placementAdds;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl4 = false;
                this.appPlacementRepo.upsert(it);
            }
        }
        this.syncIconChangesWithDrive(iconId, removeIcon, (AppSettings)origin, profileId);
        this.coreAppRepo.upsertCoreApp(updated);
        return this.getCoreApp(updated.getId());
    }

    public static /* synthetic */ CoreAppSettings updateCoreApp$default(AppSettingsService appSettingsService, CoreAppId coreAppId, ProfileId profileId, Boolean bl, HexColor hexColor, HexColor hexColor2, DocumentId documentId, Boolean bl2, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateCoreApp");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            hexColor = null;
        }
        if ((n & 0x10) != 0) {
            hexColor2 = null;
        }
        if ((n & 0x20) != 0) {
            documentId = null;
        }
        if ((n & 0x40) != 0) {
            bl2 = null;
        }
        if ((n & 0x80) != 0) {
            list = null;
        }
        if ((n & 0x100) != 0) {
            list2 = null;
        }
        return appSettingsService.updateCoreApp(coreAppId, profileId, bl, hexColor, hexColor2, documentId, bl2, list, list2);
    }

    @NotNull
    public ExternalAppSettings updateExternalApp(@NotNull ExternalAppId id, @NotNull ProfileId profileId, @Nullable Boolean active, @Nullable Collection<? extends ExternalAppSettings.Client> clients, @Nullable HexColor homeScreenAppColor, @Nullable DocumentId iconId, @Nullable Boolean removeIcon, @Nullable String name, @Nullable String url, @Nullable ExternalAppSettings.OpenUrlIn openUrlIn, @Nullable List<? extends AppPlacement> placementAdds, @Nullable List<? extends AppPlacement> placementRemoves) {
        AppPlacement it;
        String string;
        DocumentId documentId;
        Object object;
        Object object2;
        Object object3;
        Set set;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ExternalAppSettings origin = this.getExternalApp(id);
        Boolean bl = active;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getActive();
        Set set2 = clients;
        if (set2 == null || (set2 = CollectionsKt.toSet((Iterable)set2)) == null) {
            set2 = set = origin.getClients();
        }
        if ((object3 = homeScreenAppColor) == null) {
            object3 = object2 = origin.getHomeScreenAppColor();
        }
        if ((object = iconId) == null) {
            object = documentId = Intrinsics.areEqual((Object)removeIcon, (Object)true) ? null : origin.getIconId();
        }
        if ((string = name) == null) {
            string = origin.getName();
        }
        String string2 = string;
        String string3 = url;
        String string4 = string3 != null ? ExternalAppSettings.Companion.validateUrl(string3) : origin.getUrl();
        ExternalAppSettings.OpenUrlIn openUrlIn2 = openUrlIn;
        if (openUrlIn2 == null) {
            openUrlIn2 = origin.getOpenUrlIn();
        }
        ExternalAppSettings.OpenUrlIn openUrlIn3 = openUrlIn2;
        ExternalAppSettings updated = ExternalAppSettings.copy$default((ExternalAppSettings)origin, null, (boolean)bl2, (DocumentId)documentId, (String)string2, (ExternalAppSettings.OpenUrlIn)openUrlIn3, (String)string4, (HexColor)object2, (int)0, null, (Set)set, (int)385, null);
        List<? extends AppPlacement> list = placementRemoves;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl3 = false;
                this.appPlacementRepo.delete(it);
            }
        }
        List<? extends AppPlacement> list2 = placementAdds;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl4 = false;
                this.appPlacementRepo.upsert(it);
            }
        }
        this.syncIconChangesWithDrive(iconId, removeIcon, (AppSettings)origin, profileId);
        this.externalAppSettingsRepo.upsert(updated);
        return this.getExternalApp(id);
    }

    /*
     * WARNING - void declaration
     */
    public void saveAppPositions(@NotNull List<? extends AppId> appIds, @NotNull TenantId tenantId) {
        void $this$forEach$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set coreApps = this.coreAppRepo.getCoreAppsByTenantId(tenantId);
        Set externalApps = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        Iterable iterable = SetsKt.plus((Set)coreApps, (Iterable)externalApps);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$map22 = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppSettings appSettings = (AppSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List originAppIds = (List)destination$iv$iv;
        List allAppIds = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)appIds, (Iterable)originAppIds));
        this.appHomeScreenPositionRepo.deleteAllByTenantId(tenantId);
        Iterable $i$f$map22 = allAppIds;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void appId;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AppId appId2 = (AppId)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new AppHomeScreenPosition((AppId)appId, (int)index, tenantId));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppHomeScreenPosition it = (AppHomeScreenPosition)element$iv;
            boolean bl = false;
            this.appHomeScreenPositionRepo.upsert(it);
        }
    }

    @NotNull
    public AppSettings getApp(@NotNull AppId id) {
        AppSettings appSettings;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AppId appId = id;
        if (appId instanceof CoreAppId) {
            appSettings = (AppSettings)this.getCoreApp((CoreAppId)id);
        } else if (appId instanceof ExternalAppId) {
            appSettings = (AppSettings)this.getExternalApp((ExternalAppId)id);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return appSettings;
    }

    @NotNull
    public Set<CoreAppSettings> getCoreAppsByApp(@NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        return this.coreAppRepo.getCoreAppsByApp(app);
    }

    @NotNull
    public CoreAppSettings getCoreApp(@NotNull CoreAppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CoreAppSettings coreAppSettings = this.coreAppRepo.findCoreApp(id);
        if (coreAppSettings == null) {
            throw new NotFoundException("No CoreAppSettings with id: '" + id + "' found.");
        }
        return coreAppSettings;
    }

    @NotNull
    public CoreAppSettings getCoreApp(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        CoreAppId id = CoreAppId.Companion.fromAppAndTenantId(app, tenantId);
        return this.getCoreApp(id);
    }

    @NotNull
    public ExternalAppSettings getExternalApp(@NotNull ExternalAppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ExternalAppSettings externalAppSettings = this.externalAppSettingsRepo.findExternalAppSettings(id);
        if (externalAppSettings == null) {
            throw new NotFoundException("No ExternalAppSettings with id: '" + id + "' found.");
        }
        return externalAppSettings;
    }

    @NotNull
    public List<AppSettings> getAppsByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)this.getCoreAppsByTenant(tenantId), (Iterable)this.getExternalApps(tenantId));
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<AppSettings, Set<AppPlacement>> getAppsWithPlacements(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$associateWith$iv = this.getAppsByTenant(tenantId);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            AppSettings appSettings = (AppSettings)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Set set = this.getPlacements(it.getId());
            map.put(t, set);
        }
        return result$iv;
    }

    @NotNull
    public List<CoreAppSettings> getCoreAppsByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = this.coreAppRepo.getCoreAppsByTenantId(tenantId);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public List<ExternalAppSettings> getExternalApps(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Set<AppPlacement> getPlacements(@NotNull AppId appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        return this.appPlacementRepo.getByAppId(appId);
    }

    public int getLastPosition(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.appHomeScreenPositionRepo.getLastPosition(tenantId);
    }

    public void deleteCoreApp(@NotNull CoreAppSettings coreApp, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)coreApp, (String)"coreApp");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (!(coreApp.getApp() == CoreApp.CONNECT || coreApp.getApp() == CoreApp.TASKS)) {
            boolean bl = false;
            String string = coreApp.getApp() + " can't be deleted!";
            throw new IllegalArgumentException(string.toString());
        }
        this.appPlacementRepo.deleteByAppId((AppId)coreApp.getId());
        this.coreAppRepo.deleteLegacyAppById(coreApp.getId());
        this.driveApiConnector.deleteFile(coreApp.getIconId(), profileId);
        this.saveAppPositions(CollectionsKt.emptyList(), coreApp.getTenantId());
    }

    public void deleteExternalApp(@NotNull ExternalAppSettings app, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.appPlacementRepo.deleteByAppId((AppId)app.getId());
        this.externalAppSettingsRepo.deleteById(app.getId());
        this.driveApiConnector.deleteFile(app.getIconId(), profileId);
        this.saveAppPositions(CollectionsKt.emptyList(), app.getTenantId());
    }

    public void deleteAppPlacements(@NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.appPlacementRepo.deleteByUserId(userId);
    }

    private void upsertAppPosition(AppSettings app) {
        AppHomeScreenPosition it = new AppHomeScreenPosition(app.getId(), app.getPosition(), app.getTenantId());
        boolean bl = false;
        this.appHomeScreenPositionRepo.upsert(it);
    }

    private void syncIconChangesWithDrive(DocumentId iconId, Boolean removeIcon, AppSettings origin, ProfileId profileId) {
        if (iconId != null && !Intrinsics.areEqual((Object)iconId, (Object)origin.getIconId())) {
            this.driveApiConnector.replaceFile(origin.getIconId(), iconId, origin.getTenantId(), profileId);
        } else if (Intrinsics.areEqual((Object)removeIcon, (Object)true)) {
            this.driveApiConnector.deleteFile(origin.getIconId(), profileId);
        }
    }
}

