/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.toro;

import de.justsoftware.admin.graphql.generated.types.ApiToken;
import de.justsoftware.admin.id.TenantId;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u0013\u001a\u00020\b2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u00102\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/admin/connector/toro/ToroConnector;", "", "toroInternalUrl", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "deleteAppHomeScreenPositionsOfUsers", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "deleteScimToken", "", "generateScimToken", "Lde/justsoftware/admin/graphql/generated/types/ApiToken;", "getFieldMapping", "", "", "getScimToken", "replaceFieldMapping", "mapping", "admin-service"})
public class ToroConnector {
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestTemplate restTemplate;

    public ToroConnector(@Value(value="${just.toro.internal.host.url}") @NotNull String toroInternalUrl, @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.toroInternalUrl = toroInternalUrl;
        this.restTemplate = restTemplate;
    }

    public void deleteAppHomeScreenPositionsOfUsers(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.restTemplate.delete(this.toroInternalUrl + "/home-screen-app-positions/" + tenantId, new Object[0]);
    }

    @Nullable
    public ApiToken getScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (ApiToken)WebClient.create().get().uri(this.toroInternalUrl + "/scim/token?tenantId=" + tenantId, new Object[0]).retrieve().bodyToMono(ApiToken.class).block();
    }

    @NotNull
    public Map<String, Set<String>> getFieldMapping(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Map mapping = (Map)WebClient.create().get().uri(this.toroInternalUrl + "/profile/scim/fieldmapping?tenantId=" + tenantId, new Object[0]).retrieve().bodyToMono(Map.class).block();
        Intrinsics.checkNotNull((Object)mapping, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Set<kotlin.String>>");
        return mapping;
    }

    public void replaceFieldMapping(@NotNull Map<String, ? extends Set<String>> mapping, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ((WebClient.RequestBodySpec)WebClient.create().post().uri(this.toroInternalUrl + "/profile/scim/fieldmapping?tenantId=" + tenantId, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue(mapping).retrieve().toEntity(Void.class).block();
    }

    @NotNull
    public ApiToken generateScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Object object = ((WebClient.RequestBodySpec)WebClient.create().post().uri(this.toroInternalUrl + "/scim/token?tenantId=" + tenantId, new Object[0])).retrieve().bodyToMono(ApiToken.class).block();
        Intrinsics.checkNotNull((Object)object);
        return (ApiToken)object;
    }

    public boolean deleteScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WebClient.create().delete().uri(this.toroInternalUrl + "/scim/token?tenantId=" + tenantId, new Object[0]).retrieve().toEntity(Void.class).block();
        return true;
    }
}

