/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.tenant.ScimConfigService;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/admin/application/web/ScimConfigApplicationService;", "", "scimConfigService", "Lde/justsoftware/admin/domain/tenant/ScimConfigService;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "(Lde/justsoftware/admin/domain/tenant/ScimConfigService;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;)V", "getAllScimFields", "", "", "authCtx", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "replaceAllScimFields", "fields", "", "setScimFieldsToDefault", "", "admin-service"})
public class ScimConfigApplicationService {
    @NotNull
    private final ScimConfigService scimConfigService;
    @NotNull
    private final SuperopertyConnector superopertyConnector;

    public ScimConfigApplicationService(@NotNull ScimConfigService scimConfigService, @NotNull SuperopertyConnector superopertyConnector) {
        Intrinsics.checkNotNullParameter((Object)scimConfigService, (String)"scimConfigService");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        this.scimConfigService = scimConfigService;
        this.superopertyConnector = superopertyConnector;
    }

    @NotNull
    public Set<String> getAllScimFields(@NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        authCtx.checkTenantManager();
        return this.scimConfigService.getAllScimFields(authCtx.getNonNullTenantId());
    }

    @NotNull
    public Set<String> replaceAllScimFields(@NotNull Collection<String> fields, @NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        if (!this.superopertyConnector.isScimEnabled()) {
            throw new NotAllowedException("Scim is not enabled");
        }
        authCtx.checkTenantManager();
        return this.scimConfigService.replaceAllScimFields(fields, authCtx.getNonNullTenantId());
    }

    public void setScimFieldsToDefault(@NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        if (!this.superopertyConnector.isScimEnabled()) {
            throw new NotAllowedException("Scim is not enabled");
        }
        authCtx.checkTenantManager();
        this.scimConfigService.setScimFieldsToDefault(authCtx.getNonNullTenantId());
    }
}

