/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal;

import de.justsoftware.admin.application.internal.AppSettingsToggleListenerApplicationService;
import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.appsettings.AppSettingsPermissionService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0012J\b\u0010\u0014\u001a\u00020\u0010H\u0012J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0012J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/admin/application/internal/AppSettingsToggleListenerApplicationService;", "", "appSettingsPermissionService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;Lde/justsoftware/admin/application/util/TransactionSupport;Lde/justsoftware/admin/domain/tenant/TenantService;)V", "createCoreAppForEachTenant", "", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "createOrDeleteConnectApps", "createOrDeleteTasksApps", "deleteCoreApps", "apps", "", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "refreshScopeChange", "event", "Lorg/springframework/cloud/context/scope/refresh/RefreshScopeRefreshedEvent;", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsToggleListenerApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsToggleListenerApplicationService.kt\nde/justsoftware/admin/application/internal/AppSettingsToggleListenerApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n1360#2:100\n1446#2,5:101\n*S KotlinDebug\n*F\n+ 1 AppSettingsToggleListenerApplicationService.kt\nde/justsoftware/admin/application/internal/AppSettingsToggleListenerApplicationService\n*L\n66#1:96\n66#1:97,3\n79#1:100\n79#1:101,5\n*E\n"})
public class AppSettingsToggleListenerApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppSettingsPermissionService appSettingsPermissionService;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private static final Logger log;

    public AppSettingsToggleListenerApplicationService(@NotNull AppSettingsPermissionService appSettingsPermissionService, @NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull SuperopertyConnector superopertyConnector, @NotNull TransactionSupport transactionSupport, @NotNull TenantService tenantService) {
        Intrinsics.checkNotNullParameter((Object)appSettingsPermissionService, (String)"appSettingsPermissionService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        this.appSettingsPermissionService = appSettingsPermissionService;
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.superopertyConnector = superopertyConnector;
        this.transactionSupport = transactionSupport;
        this.tenantService = tenantService;
    }

    @EventListener(value={RefreshScopeRefreshedEvent.class})
    @Transactional
    public void refreshScopeChange(@NotNull RefreshScopeRefreshedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            this.createOrDeleteConnectApps();
            this.createOrDeleteTasksApps();
        }
        catch (Exception e) {
            log.error("error when reloading feature toggles", (Throwable)e);
        }
    }

    private void createOrDeleteConnectApps() {
        Set existingConnectApps = this.appSettingsService.getCoreAppsByApp(CoreApp.CONNECT);
        if (this.superopertyConnector.isConnectAppEnabled()) {
            if (existingConnectApps.isEmpty()) {
                this.createCoreAppForEachTenant(CoreApp.CONNECT);
            }
        } else {
            this.deleteCoreApps(existingConnectApps);
        }
    }

    private void createOrDeleteTasksApps() {
        Set existingTasksApps = this.appSettingsService.getCoreAppsByApp(CoreApp.TASKS);
        if (this.superopertyConnector.isTasksAppEnabled()) {
            if (existingTasksApps.isEmpty()) {
                this.createCoreAppForEachTenant(CoreApp.TASKS);
            }
        } else {
            this.deleteCoreApps(existingTasksApps);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createCoreAppForEachTenant(CoreApp app) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tenantService.getTenants();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tenant tenant = (Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.appSettingsService.createCoreApp(it.getId(), app));
        }
        List newCoreApps = (List)destination$iv$iv;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    private void deleteCoreApps(Set<CoreAppSettings> apps) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = apps;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CoreAppSettings it = (CoreAppSettings)element$iv$iv;
            boolean bl = false;
            this.appSettingsService.deleteCoreApp(it, ProfileId.Companion.fromValue(0L));
            Iterable list$iv$iv = this.appSettingsPermissionService.deletePermissions(it.getTenantId(), it.getApp());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List deletedPermissionsOfAllApps = (List)destination$iv$iv;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(AppSettingsToggleListenerApplicationService $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ AppSettingsService access$getAppSettingsService$p(AppSettingsToggleListenerApplicationService $this) {
        return $this.appSettingsService;
    }

    static {
        Logger logger = LoggerFactory.getLogger(AppSettingsToggleListenerApplicationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

