/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.content.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.content.ContentExtractionException;
import de.justsoftware.drive.content.ContentExtractionService;
import de.justsoftware.drive.content.KafkaConfigurationProvider;
import de.justsoftware.drive.content.SearchIndexUpdateService;
import de.justsoftware.drive.content.kafka.AbstractKafkaConsumer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(scopeName="prototype")
@Service
@ParametersAreNonnullByDefault
public class ExtractionRunner
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.search.index.content";
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionRunner.class);
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private final ContentExtractionService _extractionService;
    private final SearchIndexUpdateService _solrUpdateService;

    @Autowired
    public ExtractionRunner(KafkaConfigurationProvider kafkaConfigurationProvider, ContentExtractionService contentExtractionService, SearchIndexUpdateService searchIndexUpdateService) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.ContentExtractor", 1), contentExtractionService, searchIndexUpdateService);
    }

    @VisibleForTesting
    ExtractionRunner(@Nullable Consumer<String, String> consumer, ContentExtractionService contentExtractionService, SearchIndexUpdateService searchIndexUpdateService) {
        super(consumer, TOPIC, THREAD_COUNTER.getAndIncrement());
        this._extractionService = contentExtractionService;
        this._solrUpdateService = searchIndexUpdateService;
    }

    protected Logger getLog() {
        return LOG;
    }

    protected int getPriority() {
        return 1;
    }

    protected void process(ConsumerRecords<String, String> records) {
        if (records.count() > 1) {
            LOG.error("this consumer can handle only a single object, but {} records should be processed", (Object)records.count());
        }
        for (ConsumerRecord record : records) {
            this.processRecord(record);
        }
    }

    @VisibleForTesting
    void processRecord(ConsumerRecord<String, String> record) {
        String value = (String)record.value();
        String key = (String)record.key();
        if (Strings.isNullOrEmpty((String)key)) {
            LOG.info("skipping record for value {} as document id is missing", (Object)value);
            return;
        }
        if (Strings.isNullOrEmpty((String)value)) {
            LOG.info("skipping record for key {} as storageId is missing", (Object)key);
            return;
        }
        LOG.info("processing {} - {}", (Object)key, (Object)value);
        this.commit();
        String content = this.getContent(key, value);
        this.sendContentToSolr(key, value, Strings.nullToEmpty((String)content));
    }

    private void sendContentToSolr(String key, String value, String content) {
        try {
            this._solrUpdateService.update(key, content);
            return;
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            this.checkSolr(key, value, (Exception)e);
            try {
                this._solrUpdateService.update(key, content);
                return;
            }
            catch (IOException | RuntimeException | SolrServerException e2) {
                this.checkSolr(key, value, (Exception)e2);
                LOG.error(String.format("solr is available but sending failed while processing record: %s, %s", key, value), e2);
                return;
            }
        }
    }

    private void checkSolr(String key, String value, Exception e) {
        if (!this._solrUpdateService.isSolrAvailable()) {
            throw new AbstractKafkaConsumer.StopProcessingException(String.format("solr is not available while processing record: %s, %s", key, value), (Throwable)e);
        }
    }

    @CheckForNull
    private String getContent(String key, String value) {
        StorageId storageId = new StorageId(value);
        try {
            return this._extractionService.parse(storageId);
        }
        catch (ContentExtractionException | RuntimeException e) {
            this.checkStorage(key, value, e);
            try {
                return this._extractionService.parse(storageId);
            }
            catch (ContentExtractionException | RuntimeException e2) {
                this.checkStorage(key, value, e2);
                LOG.error(String.format("storage is available but extraction failed while processing record: %s, %s", key, value), e2);
                return null;
            }
        }
    }

    private void checkStorage(String key, String value, Throwable e) {
        if (!this._extractionService.isStorageAvailable()) {
            throw new AbstractKafkaConsumer.StopProcessingException(String.format("storage is not available while processing record: %s, %s", key, value), e);
        }
    }
}

