/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.Protocol;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;

public class ProtoUtils {
    private static Schema schemaFor(Schema[][] schemas, int apiKey, int version) {
        if (apiKey < 0 || apiKey > schemas.length) {
            throw new IllegalArgumentException("Invalid api key: " + apiKey);
        }
        Schema[] versions = schemas[apiKey];
        if (version < 0 || version > versions.length) {
            throw new IllegalArgumentException("Invalid version for API key " + apiKey + ": " + version);
        }
        if (versions[version] == null) {
            throw new IllegalArgumentException("Unsupported version for API key " + apiKey + ": " + version);
        }
        return versions[version];
    }

    public static short latestVersion(int apiKey) {
        if (apiKey < 0 || apiKey >= Protocol.CURR_VERSION.length) {
            throw new IllegalArgumentException("Invalid api key: " + apiKey);
        }
        return Protocol.CURR_VERSION[apiKey];
    }

    public static Schema requestSchema(int apiKey, int version) {
        return ProtoUtils.schemaFor(Protocol.REQUESTS, apiKey, version);
    }

    public static Schema currentRequestSchema(int apiKey) {
        return ProtoUtils.requestSchema(apiKey, ProtoUtils.latestVersion(apiKey));
    }

    public static Schema responseSchema(int apiKey, int version) {
        return ProtoUtils.schemaFor(Protocol.RESPONSES, apiKey, version);
    }

    public static Schema currentResponseSchema(int apiKey) {
        return ProtoUtils.schemaFor(Protocol.RESPONSES, apiKey, ProtoUtils.latestVersion(apiKey));
    }

    public static Struct parseRequest(int apiKey, int version, ByteBuffer buffer) {
        return (Struct)ProtoUtils.requestSchema(apiKey, version).read(buffer);
    }

    public static Struct parseResponse(int apiKey, ByteBuffer buffer) {
        return (Struct)ProtoUtils.currentResponseSchema(apiKey).read(buffer);
    }

    public static Struct parseResponse(int apiKey, int version, ByteBuffer buffer) {
        return (Struct)ProtoUtils.responseSchema(apiKey, version).read(buffer);
    }
}

