/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.controller;

import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.onx.security.model.JustConnectUser;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.lang.JoseException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/adfs"})
@ParametersAreNonnullByDefault
public class AdfsController {
    public static final String TORO_EXTERNAL_LOGIN_URL = "/toro/external/login";
    private final JwtGenerator _jwtGenerator;

    public AdfsController(JwtGenerator jwtGenerator) {
        this._jwtGenerator = jwtGenerator;
    }

    @RequestMapping(value={"/error"})
    public void error(HttpServletResponse response) throws IOException {
        response.setStatus(503);
        response.getWriter().println("Service Configuration incomplete");
    }

    @Nonnull
    @RequestMapping(path={"/authenticate"})
    public RedirectView authenticate(@RequestParam(value="targeturl", defaultValue="/") String targeturl, Principal principal) throws JwtKeyLoadingException, JoseException {
        RedirectView view = new RedirectView(TORO_EXTERNAL_LOGIN_URL);
        view.addStaticAttribute("targeturl", (Object)targeturl);
        view.addStaticAttribute("jwt", (Object)this.generateJWT(principal));
        return view;
    }

    @Nonnull
    private synchronized String generateJWT(Principal principal) throws JwtKeyLoadingException, JoseException {
        JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withLifetime(2L).withSubject(this.getUserId(principal));
        return this._jwtGenerator.generateJWT(claimsBuilder);
    }

    @Nonnull
    private String getUserId(Principal principal) {
        Object authPrincipal;
        if (principal instanceof Authentication && (authPrincipal = ((Authentication)principal).getPrincipal()) instanceof JustConnectUser) {
            return "" + ((JustConnectUser)authPrincipal).getId();
        }
        throw new UsernameNotFoundException("No Just Social user authenticated! Principal: " + principal.getName());
    }
}

