/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.solr.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrConfigFileUploadHandler
extends ContentStreamHandlerBase {
    private static final Logger LOG = LoggerFactory.getLogger(SolrConfigFileUploadHandler.class);

    public String getDescription() {
        return "Handler to upload solr config files to solr config folder";
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest solrqueryrequest, UpdateRequestProcessor updaterequestprocessor) {
        return new ContentStreamLoader(){

            public void load(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse, ContentStream contentStream, UpdateRequestProcessor processor) {
                SolrConfigFileUploadHandler.this.saveConfigFile(solrQueryRequest, solrQueryResponse, contentStream);
            }
        };
    }

    private void saveConfigFile(@Nonnull SolrQueryRequest req, @Nonnull SolrQueryResponse rsp, @Nonnull ContentStream contentStream) {
        String filename = req.getParams().get("file", null);
        if (filename == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Parameter file is not defined");
        }
        SolrCore core = req.getCore();
        SolrResourceLoader loader = core.getResourceLoader();
        File configdir = new File(loader.getConfigDir());
        if (!configdir.exists()) {
            try {
                configdir = new File(loader.getClassLoader().getResource(loader.getConfigDir()).toURI());
            }
            catch (URISyntaxException e) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access configuration directory!");
            }
        }
        File file = new File(configdir, filename);
        File backupFile = SolrConfigFileUploadHandler.renameOldFileToBackup(file);
        try (InputStream streamToSave = contentStream.getStream();
             FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)streamToSave, (OutputStream)outputStream);
            try {
                SolrConfigFileUploadHandler.reloadCore(core);
            }
            catch (SolrException e) {
                this.restoreBackupIfExists(core, configdir, filename, backupFile);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not load new the config file! Old config file restored!", (Throwable)e);
            }
            if (backupFile != null && !backupFile.delete()) {
                LOG.warn("Unable to delete backup file: {}", (Object)backupFile);
            }
        }
        catch (IOException e) {
            this.restoreBackupIfExists(core, configdir, filename, backupFile);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not save the config file to config dir successfully!", (Throwable)e);
        }
        rsp.add("status", (Object)"success");
        rsp.setHttpCaching(false);
    }

    @CheckForNull
    private static File renameOldFileToBackup(@Nonnull File file) {
        if (!file.isFile() || !file.exists()) {
            return null;
        }
        File backupFile = new File(file.getName() + ".bak");
        if (file.renameTo(backupFile)) {
            return backupFile;
        }
        return null;
    }

    private void restoreBackupIfExists(@Nonnull SolrCore core, @Nonnull File configDir, @Nonnull String configFilename, @Nullable File backupFile) throws SolrException {
        if (backupFile != null && backupFile.exists() && backupFile.renameTo(new File(configDir, configFilename))) {
            SolrConfigFileUploadHandler.reloadCore(core);
        }
    }

    private static void reloadCore(@Nonnull SolrCore core) throws SolrException {
        core.getCoreContainer().reload(core.getName());
    }
}

