/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.LongConsumer;
import org.apache.solr.analytics.function.mapping.DecimalNumericConversionFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.LongValueStream;

class ConvertDoubleStreamFunction
extends LongValueStream.AbstractLongValueStream {
    private final String name;
    private final DoubleValueStream param;
    private final DecimalNumericConversionFunction.ConvertDoubleFunction conv;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public ConvertDoubleStreamFunction(String name, DoubleValueStream param, DecimalNumericConversionFunction.ConvertDoubleFunction conv) {
        this.name = name;
        this.param = param;
        this.conv = conv;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        this.param.streamDoubles(value -> cons.accept(this.conv.convert(value)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

