/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import de.justsoftware.people.application.ConfigApplicationService;
import de.justsoftware.people.application.model.CreateLinkDto;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.config.FeatureToggleService;
import de.justsoftware.people.controller.model.Config;
import de.justsoftware.people.model.ExternalLinkId;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/config"})
@ParametersAreNonnullByDefault
public class ConfigController {
    private final ConfigApplicationService _applicationService;
    private final FeatureToggleService _featureToggleService;

    @Autowired
    public ConfigController(ConfigApplicationService applicationService, FeatureToggleService featureToggleService) {
        this._applicationService = applicationService;
        this._featureToggleService = featureToggleService;
    }

    @Nonnull
    @GetMapping
    @Operation(summary="Get the config object for the people webclient.")
    public Config config(AuthorizationContext authCtx) {
        boolean hasConfiguredLinks = !this._applicationService.getExternalLinks(authCtx.getTenantId(), authCtx).isEmpty();
        return new Config(authCtx.getProfileId(), this.mayCreateUserGroups(authCtx), this._featureToggleService.getExternalSearchUrl(), this._featureToggleService.getExternalSearchProfileFieldId(), hasConfiguredLinks, this.mayManageTenant(authCtx), this.mayExportUsers(authCtx));
    }

    private boolean mayCreateUserGroups(AuthorizationContext authCtx) {
        return authCtx.may(Role.writeApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)authCtx.getTenantId().getId())));
    }

    private boolean mayManageTenant(AuthorizationContext authCtx) {
        return authCtx.may(Role.manage((String)authCtx.getTenantId().toString()));
    }

    private boolean mayExportUsers(AuthorizationContext authCtx) {
        return authCtx.may(Role.exportApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)authCtx.getTenantId().getId())));
    }

    @Nonnull
    @PostMapping(path={"/link"})
    @Operation(summary="Creates a link pointing to an external resource")
    public ExternalLinkId createExternalLink(AuthorizationContext authCtx, @RequestBody CreateLinkDto createLinkDto) {
        return this._applicationService.createExternalLink(authCtx.getTenantId(), createLinkDto, authCtx);
    }

    @Nonnull
    @GetMapping(path={"/links"})
    @Operation(summary="List all configured external links on a tenant")
    public List<ExternalLinkConfig> getExternalLinks(AuthorizationContext authCtx) {
        return this._applicationService.getExternalLinks(authCtx.getTenantId(), authCtx);
    }

    @DeleteMapping(path={"/links"})
    @Operation(summary="Delete all the given external links on the given tenant")
    public void deleteExternalLinks(AuthorizationContext authCtx, @RequestBody List<ExternalLinkId> linkIds) {
        this._applicationService.deleteExternalLinks(authCtx.getTenantId(), linkIds, authCtx);
    }
}

