/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.people.authorization.AuthorizationContextProvider;
import de.justsoftware.people.config.AuthorizationContextResolver;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ParametersAreNonnullByDefault
public class PeopleWebConfig
implements WebMvcConfigurer {
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final String _toroBaseUrl;
    private final ObjectMapper _objectMapper;

    @Autowired
    public PeopleWebConfig(AuthorizationContextProvider authorizationContextProvider, @Value(value="${just.people.toro.internal.baseUrl}") String toroBaseUrl, ObjectMapper objectMapper) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._toroBaseUrl = toroBaseUrl;
        this._objectMapper = objectMapper;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthorizationContextResolver(this._authorizationContextProvider, this._toroBaseUrl, this._objectMapper));
    }
}

