/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.business.search.model.SearchField;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchFilter {
    private final SearchField _searchField;
    private final ImmutableList<String> _values;

    public SearchFilter(SearchField searchableField, ImmutableList<String> values) {
        this._searchField = searchableField;
        this._values = (ImmutableList)values.stream().filter(value -> !Strings.isNullOrEmpty((String)value)).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!this._values.isEmpty() ? 1 : 0) != 0, (Object)"Search filter must contain at least one non-empty filter value");
    }

    @Nonnull
    public SearchField getSearchField() {
        return this._searchField;
    }

    @Nonnull
    public ImmutableList<String> getValues() {
        return this._values;
    }
}

