/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import de.justsoftware.people.business.event.ProfileTenantsUpdatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.DeletableProfile;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.model.DynamicProfileFields;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.ProfileAttributeRepository;
import de.justsoftware.people.persistence.ProfileRepository;
import de.justsoftware.people.persistence.ProfileTenantRepository;
import de.justsoftware.people.persistence.model.DbProfile;
import de.justsoftware.people.persistence.model.DbProfileAttribute;
import de.justsoftware.people.persistence.model.DbProfileTenant;
import de.justsoftware.people.persistence.transaction.TransactionSupport;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0012H\u0016J#\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010!0 H\u0011\u00a2\u0006\u0002\b\"J!\u0010#\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020$0 H\u0011\u00a2\u0006\u0002\b%J)\u0010&\u001a\u00020\u001e2\u001a\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010'0 H\u0011\u00a2\u0006\u0002\b(J$\u0010)\u001a\u00020\u001e2\u001a\u0010*\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0004\u0012\u00020+\u0018\u00010\u00120\u0010H\u0012J\"\u0010,\u001a\u00020\u001e2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130.0\u0010H\u0012R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/justsoftware/people/business/profile/ProfileService;", "", "profileRepository", "Lde/justsoftware/people/persistence/ProfileRepository;", "profileTenantRepository", "Lde/justsoftware/people/persistence/ProfileTenantRepository;", "profileAttributeRepository", "Lde/justsoftware/people/persistence/ProfileAttributeRepository;", "transactionSupport", "Lde/justsoftware/people/persistence/transaction/TransactionSupport;", "externalLinkService", "Lde/justsoftware/people/business/externallink/ExternalLinkService;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/people/persistence/ProfileRepository;Lde/justsoftware/people/persistence/ProfileTenantRepository;Lde/justsoftware/people/persistence/ProfileAttributeRepository;Lde/justsoftware/people/persistence/transaction/TransactionSupport;Lde/justsoftware/people/business/externallink/ExternalLinkService;Lorg/springframework/context/ApplicationEventPublisher;)V", "findTenantsByProfileIds", "", "Lde/justsoftware/people/model/ProfileId;", "", "Lde/justsoftware/people/model/TenantId;", "profileIds", "", "findUndeletedProfileByIds", "Lde/justsoftware/people/business/profile/model/Profile;", "getProfile", "profileSearchReadModel", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "configuredLinks", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "onProfileAttributesChanged", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/model/DynamicProfileFields;", "onProfileAttributesChanged$people_api", "onProfileChanged", "Lde/justsoftware/people/business/profile/model/DeletableProfile;", "onProfileChanged$people_api", "onProfileTenantChanged", "", "onProfileTenantChanged$people_api", "saveProfileAttributes", "profileAttributes", "Lde/justsoftware/people/persistence/model/DbProfileAttribute;", "saveTenants", "tenantsToSave", "", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,197:1\n1549#2:198\n1620#2,3:199\n1360#2:202\n1446#2,2:203\n1620#2,3:206\n1448#2,3:209\n1194#2,2:212\n1222#2,4:214\n1549#2:218\n1620#2,3:219\n1360#2:222\n1446#2,5:223\n1490#2:228\n1520#2,3:229\n1523#2,3:239\n1194#2,2:242\n1222#2,4:244\n1855#2:255\n1856#2:259\n1194#2,2:261\n1222#2,4:263\n1238#2,4:269\n1194#2,2:273\n1222#2,4:275\n1238#2,4:281\n1549#2:285\n1620#2,3:286\n1855#2,2:289\n1549#2:294\n1620#2,3:295\n1549#2:301\n1620#2,3:302\n1855#2,2:305\n17#3:205\n7#3,3:252\n10#3,3:256\n13#3:260\n372#4,7:232\n453#4:267\n403#4:268\n453#4:279\n403#4:280\n494#4,7:307\n125#5:248\n152#5,3:249\n76#5:291\n96#5,2:292\n98#5,3:298\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n*L\n75#1:198\n75#1:199,3\n77#1:202\n77#1:203,2\n80#1:206,3\n77#1:209,3\n81#1:212,2\n81#1:214,4\n85#1:218\n85#1:219,3\n87#1:222\n87#1:223,5\n88#1:228\n88#1:229,3\n88#1:239,3\n99#1:242,2\n99#1:244,4\n102#1:255\n102#1:259\n121#1:261,2\n121#1:263,4\n122#1:269,4\n138#1:273,2\n138#1:275,4\n139#1:281,4\n148#1:285\n148#1:286,3\n150#1:289,2\n154#1:294\n154#1:295,3\n171#1:301\n171#1:302,3\n173#1:305,2\n80#1:205\n102#1:252,3\n102#1:256,3\n102#1:260\n88#1:232,7\n122#1:267\n122#1:268\n139#1:279\n139#1:280\n177#1:307,7\n100#1:248\n100#1:249,3\n153#1:291\n153#1:292,2\n153#1:298,3\n*E\n"})
public class ProfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final ProfileTenantRepository profileTenantRepository;
    @NotNull
    private final ProfileAttributeRepository profileAttributeRepository;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ExternalLinkService externalLinkService;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    public static final String PERSON_TOPIC = "just.persons";
    @NotNull
    public static final String PERSON_TENANT_TOPIC = "just.persons.tenantIds";
    @NotNull
    public static final String PERSON_PROFILE_ATTRIBUTES_TOPIC = "just.persons.profileAttributes";
    @NotNull
    private static final String PROFILE_LISTENER_ID = "profileConsumer";
    @NotNull
    private static final String PROFILE_TENANT_LISTENER_ID = "profileTenantConsumer";
    @NotNull
    private static final String PROFILE_ATTRIBUTES_LISTENER_ID = "profileAttributesConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileService.class);

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull ProfileTenantRepository profileTenantRepository, @NotNull ProfileAttributeRepository profileAttributeRepository, @NotNull TransactionSupport transactionSupport, @NotNull ExternalLinkService externalLinkService, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)profileTenantRepository, (String)"profileTenantRepository");
        Intrinsics.checkNotNullParameter((Object)profileAttributeRepository, (String)"profileAttributeRepository");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)externalLinkService, (String)"externalLinkService");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.profileRepository = profileRepository;
        this.profileTenantRepository = profileTenantRepository;
        this.profileAttributeRepository = profileAttributeRepository;
        this.transactionSupport = transactionSupport;
        this.externalLinkService = externalLinkService;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel, @NotNull List<ExternalLinkConfig> configuredLinks) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        Intrinsics.checkNotNullParameter(configuredLinks, (String)"configuredLinks");
        Map map = profileSearchReadModel.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getFields(...)");
        Map fields = map;
        if (fields.isEmpty()) {
            return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
        }
        List links = this.externalLinkService.getLinkFromConfigAndData(configuredLinks, fields);
        return Profile.Companion.toProfile(profileSearchReadModel, links);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findUndeletedProfileByIds(@NotNull Iterable<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable<ProfileId> $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable<ProfileId> iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)p0.getId()).longValue());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            List chunk = (List)element$iv$iv;
            boolean bl = false;
            Map attributes = DbProfileAttribute.Companion.toDynamicProfileFields((Iterable)this.profileAttributeRepository.findAllByProfileIdIn((Iterable)chunk));
            List profiles = this.profileRepository.findAllByDeletedIsFalseAndIdIn((Iterable)chunk);
            Iterable $this$mapToSet$iv = profiles;
            boolean $i$f$mapToSet = false;
            Iterable iterable2 = $this$mapToSet$iv;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbProfile dbProfile = (DbProfile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object2 = (DynamicProfileFields)attributes.get(new ProfileId(it.getId()));
                if (object2 == null || (object2 = object2.getFields()) == null) {
                    object2 = MapsKt.emptyMap();
                }
                collection.add(DbProfile.Companion.toProfile$default((DbProfile.Companion)DbProfile.Companion, (DbProfile)it, (Map)object2, null, (int)2, null));
            }
            Iterable list$iv$iv = (Set)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, List<TenantId>> findTenantsByProfileIds(@NotNull Iterable<ProfileId> profileIds) {
        void $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileTenantRepository $i$f$map22 = this.profileTenantRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllByProfileIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        Iterable $i$f$flatMap22 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            DbProfileTenant it2 = (DbProfileTenant)element$iv$iv;
            boolean $i$a$-groupBy-ProfileService$findTenantsByProfileIds$52 = false;
            ProfileId key$iv$iv = new ProfileId(it2.getProfileId());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            DbProfileTenant $i$a$-groupBy-ProfileService$findTenantsByProfileIds$52 = (DbProfileTenant)element$iv$iv;
            collection = list$iv$iv;
            boolean bl = false;
            collection.add(new TenantId(it.getTenantId()));
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileConsumer", containerFactory="profileListenerFactory", topics={"just.persons"}, idIsGroup=false)
    public void onProfileChanged$people_api(@NotNull ConsumerRecords<ProfileId, DeletableProfile> records) {
        Object object;
        void $this$mapTo$iv$iv;
        ArrayList<DbProfile> arrayList;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        Map capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            object = item$iv$iv;
            arrayList = destination$iv$iv2;
            boolean bl = false;
            ConsumerRecord record = (ConsumerRecord)object.getValue();
            Object object2 = record.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
            arrayList.add(DbProfile.Companion.toDbProfile((DeletableProfile)object2));
        }
        List updatedProfiles = (List)destination$iv$iv2;
        this.profileRepository.saveAll((Iterable)updatedProfiles);
        Iterable $this$partition$iv = updatedProfiles;
        boolean $i$f$partition = false;
        ArrayList<DbProfile> first$iv = new ArrayList<DbProfile>();
        ArrayList second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partition$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv.iterator();
        while (object.hasNext()) {
            void p0;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = object.next();
            boolean bl = false;
            DbProfile p02 = (DbProfile)element$iv;
            boolean $i$a$-partition-ProfileService$onProfileChanged$32 = false;
            ArrayList<DbProfile> target$iv = p02.getDeleted() ? first$iv : second$iv;
            DbProfile $i$a$-partition-ProfileService$onProfileChanged$32 = (DbProfile)element$iv;
            arrayList = target$iv;
            boolean bl2 = false;
            arrayList.add((DbProfile)Long.valueOf(p0.getId()));
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List deleted = (List)pair.component1();
        List updated = (List)pair.component2();
        if (!((Collection)deleted).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesDeletedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)deleted)));
        }
        if (!((Collection)updated).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)updated)));
        }
        LOG.info("Updated " + ((Collection)updatedProfiles).size() + " profiles");
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileAttributesConsumer", containerFactory="profileAttributesListenerFactory", topics={"just.persons.profileAttributes"}, idIsGroup=false)
    public void onProfileAttributesChanged$people_api(@NotNull ConsumerRecords<ProfileId, DynamicProfileFields> records) {
        void $this$mapValuesTo$iv$iv;
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List list;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            ConsumerRecord records2 = (ConsumerRecord)entry.getValue();
            DynamicProfileFields dynamicProfileFields = (DynamicProfileFields)records2.value();
            if (dynamicProfileFields != null) {
                Intrinsics.checkNotNull((Object)profileId);
                list = DbProfileAttribute.Companion.toDbProfileAttributes(dynamicProfileFields, profileId);
            } else {
                list = null;
            }
            List list2 = list;
            map.put(k, list2);
        }
        Map attributeChanges = destination$iv$iv2;
        this.saveProfileAttributes(attributeChanges);
        LOG.info("Updated profile attributes of " + attributeChanges.size() + " profiles");
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileTenantConsumer", containerFactory="profileTenantListenerFactory", topics={"just.persons.tenantIds"}, idIsGroup=false)
    public void onProfileTenantChanged$people_api(@NotNull ConsumerRecords<ProfileId, TenantId[]> records) {
        void $this$mapValuesTo$iv$iv;
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            Object object = (TenantId[])((ConsumerRecord)entry.getValue()).value();
            if (object == null || (object = ArraysKt.toSet((Object[])object)) == null) {
                object = SetsKt.emptySet();
            }
            Object object2 = object;
            map.put(k, object2);
        }
        Map tenantsToSave = destination$iv$iv2;
        this.saveTenants(tenantsToSave);
        LOG.info("Updated tenants of " + tenantsToSave.size() + " profiles");
    }

    private void saveTenants(Map<ProfileId, ? extends Set<TenantId>> tenantsToSave) {
        this.transactionSupport.doInTransaction(() -> ProfileService.saveTenants$lambda$19(tenantsToSave, this));
    }

    private void saveProfileAttributes(Map<ProfileId, ? extends List<DbProfileAttribute>> profileAttributes) {
        if (profileAttributes.isEmpty()) {
            return;
        }
        this.transactionSupport.doInTransaction(() -> ProfileService.saveProfileAttributes$lambda$23(profileAttributes, this));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, profileAttributes.keySet()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveTenants$lambda$19(Map $tenantsToSave, ProfileService this$0) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Map $this$forEach$iv;
        Map.Entry p0;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$tenantsToSave, (String)"$tenantsToSave");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$map$iv = $tenantsToSave.keySet();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileTenantRepository $i$f$map22 = this$0.profileTenantRepository;
        boolean $i$f$forEach22 = false;
        destination$iv$iv = $this$forEach$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv = destination$iv$iv.next();
            Iterable p02 = (Iterable)element$iv;
            boolean bl = false;
            $i$f$map22.deleteByProfileIdIn(p02);
        }
        $this$forEach$iv = $tenantsToSave;
        collection = this$0.profileTenantRepository;
        boolean $i$f$flatMap = false;
        void $i$f$forEach22 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator<Object> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry element$iv$iv;
            p0 = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            ProfileId profileId = (ProfileId)p0.getKey();
            Set tenantIds = (Set)p0.getValue();
            Iterable $this$map$iv2 = tenantIds;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void tenantId;
                TenantId tenantId2 = (TenantId)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new DbProfileTenant(((Number)profileId.getId()).longValue(), (UUID)tenantId.getId()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection.saveAll((List)destination$iv$iv);
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfileTenantsUpdatedEvent((Object)this$0, $tenantsToSave));
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveProfileAttributes$lambda$23(Map $profileAttributes, ProfileService this$0) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$profileAttributes, (String)"$profileAttributes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$map$iv = $profileAttributes.keySet();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileAttributeRepository $i$f$map22 = this$0.profileAttributeRepository;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            $i$f$map22.deleteByProfileIdIn(p0);
        }
        Map $this$filterValues$iv = CollectionUtilsKt.filterNotNullValues((Map)$profileAttributes);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List p0 = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(!((Collection)p0).isEmpty())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List toSave = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        if (!((Collection)toSave).isEmpty()) {
            this$0.profileAttributeRepository.saveAll((Iterable)toSave);
        }
    }
}

