/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.persistence.model;

import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.persistence.model.DbAuditModel;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@Entity
@Table(name="Notification")
@ParametersAreNonnullByDefault
@NamedEntityGraph(name="graph.Notification", attributeNodes={@NamedAttributeNode(value="localizedTitle"), @NamedAttributeNode(value="localizedText"), @NamedAttributeNode(value="localizedSecondaryText"), @NamedAttributeNode(value="localizedMailContainerName"), @NamedAttributeNode(value="localizedMailReplacementText")})
public class DbNotification
extends DbAuditModel {
    private static final long serialVersionUID = 1L;
    private UUID _id;
    private UUID _tenantId;
    private String _appId;
    private String _defaultTitle;
    private Map<Locale, String> _localizedTitle = new HashMap();
    private String _defaultText;
    private Map<Locale, String> _localizedText = new HashMap();
    private String _defaultSecondaryText;
    private Map<Locale, String> _localizedSecondaryText = new HashMap();
    private String _mailAuthorName;
    private String _defaultMailContainerName;
    private Map<Locale, String> _localizedMailContainerName = new HashMap();
    private String _defaultMailReplacementText;
    private Map<Locale, String> _localizedMailReplacementText = new HashMap();
    private Instant _timestamp;
    private String _targetId;
    private String _payload;
    private NotificationType _type;

    @Deprecated
    public DbNotification() {
    }

    public DbNotification(UUID id, UUID tenantId, String appId, String defaultTitle, String defaultText, NotificationType type, Instant timestamp) {
        this._id = id;
        this._tenantId = tenantId;
        this._appId = appId;
        this._defaultTitle = defaultTitle;
        this._defaultText = defaultText;
        this._type = type;
        this._timestamp = timestamp;
    }

    @Id
    @Nonnull
    public UUID getId() {
        return this._id;
    }

    public void setId(UUID id) {
        this._id = id;
    }

    @NotNull
    @Nonnull
    @Column(nullable=false)
    public UUID getTenantId() {
        return this._tenantId;
    }

    public void setTenantId(UUID tenantId) {
        this._tenantId = tenantId;
    }

    @NotBlank
    @Nonnull
    @Column(nullable=false)
    public String getAppId() {
        return this._appId;
    }

    public void setAppId(String appId) {
        this._appId = appId;
    }

    @NotBlank
    @Nonnull
    @Column(nullable=false)
    public String getDefaultTitle() {
        return this._defaultTitle;
    }

    public void setDefaultTitle(String defaultTitle) {
        this._defaultTitle = defaultTitle;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="locale")
    @Column(name="title", nullable=false)
    @CollectionTable(name="localized_title", joinColumns={@JoinColumn(name="notification_id")})
    @Nonnull
    public Map<Locale, String> getLocalizedTitle() {
        return this._localizedTitle;
    }

    public void setLocalizedTitle(Map<Locale, String> localizedTitle) {
        this._localizedTitle = localizedTitle;
    }

    @NotBlank
    @Nonnull
    @Column(nullable=false)
    public String getDefaultText() {
        return this._defaultText;
    }

    public void setDefaultText(String defaultText) {
        this._defaultText = defaultText;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="locale")
    @Column(name="text", nullable=false)
    @CollectionTable(name="localized_text", joinColumns={@JoinColumn(name="notification_id")})
    @Nonnull
    public Map<Locale, String> getLocalizedText() {
        return this._localizedText;
    }

    public void setLocalizedText(Map<Locale, String> localizedText) {
        this._localizedText = localizedText;
    }

    @CheckForNull
    public String getDefaultSecondaryText() {
        return this._defaultSecondaryText;
    }

    public void setDefaultSecondaryText(@Nullable String defaultSecondaryText) {
        this._defaultSecondaryText = defaultSecondaryText;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="locale")
    @Column(name="secondary_text", nullable=false)
    @CollectionTable(name="localized_secondary_text", joinColumns={@JoinColumn(name="notification_id")})
    @Nonnull
    public Map<Locale, String> getLocalizedSecondaryText() {
        return this._localizedSecondaryText;
    }

    public void setLocalizedSecondaryText(Map<Locale, String> localizedSecondaryText) {
        this._localizedSecondaryText = localizedSecondaryText;
    }

    @CheckForNull
    public String getMailAuthorName() {
        return this._mailAuthorName;
    }

    public void setMailAuthorName(@Nullable String mailAuthorName) {
        this._mailAuthorName = mailAuthorName;
    }

    @CheckForNull
    public String getDefaultMailContainerName() {
        return this._defaultMailContainerName;
    }

    public void setDefaultMailContainerName(@Nullable String defaultMailContainerName) {
        this._defaultMailContainerName = defaultMailContainerName;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="locale")
    @Column(name="mail_container_name", nullable=false)
    @CollectionTable(name="localized_mail_container_name", joinColumns={@JoinColumn(name="notification_id")})
    @Nonnull
    public Map<Locale, String> getLocalizedMailContainerName() {
        return this._localizedMailContainerName;
    }

    public void setLocalizedMailContainerName(Map<Locale, String> localizedMailContainerName) {
        this._localizedMailContainerName = localizedMailContainerName;
    }

    @CheckForNull
    public String getDefaultMailReplacementText() {
        return this._defaultMailReplacementText;
    }

    public void setDefaultMailReplacementText(@Nullable String defaultMailReplacementText) {
        this._defaultMailReplacementText = defaultMailReplacementText;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="locale")
    @Column(name="mail_replacement_text", nullable=false)
    @CollectionTable(name="localized_mail_replacement_text", joinColumns={@JoinColumn(name="notification_id")})
    @Nonnull
    public Map<Locale, String> getLocalizedMailReplacementText() {
        return this._localizedMailReplacementText;
    }

    public void setLocalizedMailReplacementText(Map<Locale, String> localizedMailReplacementText) {
        this._localizedMailReplacementText = localizedMailReplacementText;
    }

    @NotNull
    @Nonnull
    @Column(nullable=false)
    public Instant getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Instant timestamp) {
        this._timestamp = timestamp;
    }

    @CheckForNull
    public String getTargetId() {
        return this._targetId;
    }

    public void setTargetId(@Nullable String targetId) {
        this._targetId = targetId;
    }

    @CheckForNull
    public String getPayload() {
        return this._payload;
    }

    public void setPayload(@Nullable String payload) {
        this._payload = payload;
    }

    @Nonnull
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public NotificationType getType() {
        return this._type;
    }

    public void setType(NotificationType type) {
        this._type = type;
    }
}

