/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.business.CommonConfigProperties;
import de.justsoftware.notificationservice.business.JunoRestClientService;
import de.justsoftware.notificationservice.exception.JunoLoginException;
import de.justsoftware.notificationservice.exception.JunoUnauthorizedException;
import de.justsoftware.notificationservice.exception.NotFoundException;
import de.justsoftware.notificationservice.model.event.JustLicenseChangedEvent;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.netty.http.client.HttpClient;
import reactor.util.retry.Retry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!2\u0006\u0010\"\u001a\u00020\nH\u0002J\u0014\u0010#\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/notificationservice/business/JunoRestClientService;", "", "junoBasePath", "", "httpClient", "Lreactor/netty/http/client/HttpClient;", "commonConfigProperties", "Lde/justsoftware/notificationservice/business/CommonConfigProperties;", "(Ljava/lang/String;Lreactor/netty/http/client/HttpClient;Lde/justsoftware/notificationservice/business/CommonConfigProperties;)V", "lastAccessToken", "Lde/justsoftware/notificationservice/business/JunoRestClientService$JunoOAuth2AccessTokenResponse;", "lastServiceDisabledException", "Lde/justsoftware/notificationservice/business/JunoRestClientService$ServiceDisabledException;", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "checkServiceNotDisabled", "Lreactor/core/publisher/Mono;", "", "disableServiceIfFatalLicenseError", "", "error", "Lde/justsoftware/notificationservice/exception/JunoLoginException;", "getAccessToken", "login", "logout", "onLicenseChanged", "event", "Lde/justsoftware/notificationservice/model/event/JustLicenseChangedEvent;", "performLoginRequest", "license", "performSendPushNotificationsRequest", "Lde/justsoftware/pushnotification/client/model/PushNotificationResults;", "pushNotifications", "", "accessToken", "sendPushNotifications", "Companion", "JunoOAuth2AccessTokenResponse", "ServiceDisabledException", "notification-service"})
@SourceDebugExtension(value={"SMAP\nJunoRestClientService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JunoRestClientService.kt\nde/justsoftware/notificationservice/business/JunoRestClientService\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n+ 3 ClientResponseExtensions.kt\norg/springframework/web/reactive/function/client/ClientResponseExtensionsKt\n*L\n1#1,149:1\n120#2:150\n120#2:151\n38#3:152\n*S KotlinDebug\n*F\n+ 1 JunoRestClientService.kt\nde/justsoftware/notificationservice/business/JunoRestClientService\n*L\n111#1:150\n127#1:151\n121#1:152\n*E\n"})
public final class JunoRestClientService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonConfigProperties commonConfigProperties;
    @NotNull
    private final WebClient webClient;
    @Nullable
    private volatile JunoOAuth2AccessTokenResponse lastAccessToken;
    @Nullable
    private volatile ServiceDisabledException lastServiceDisabledException;
    private static final Logger LOG = LoggerFactory.getLogger(JunoRestClientService.class);

    public JunoRestClientService(@NotNull String junoBasePath, @NotNull HttpClient httpClient, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePath, (String)"junoBasePath");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        this.commonConfigProperties = commonConfigProperties;
        String[] stringArray = new String[]{"application/json"};
        WebClient webClient = WebClient.builder().baseUrl(junoBasePath).defaultHeader("Accept", stringArray).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        this.webClient = webClient;
    }

    @NotNull
    public final PushNotificationResults sendPushNotifications(@NotNull List<? extends Object> pushNotifications) {
        Intrinsics.checkNotNullParameter(pushNotifications, (String)"pushNotifications");
        Mono mono = this.checkServiceNotDisabled().then(this.getAccessToken()).flatMap(arg_0 -> JunoRestClientService.sendPushNotifications$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        Mono mono2 = MonoExtensionsKt.doOnError((Mono)MonoExtensionsKt.doOnError((Mono)mono, (KClass)Reflection.getOrCreateKotlinClass(JunoLoginException.class), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (KClass)Reflection.getOrCreateKotlinClass(JunoUnauthorizedException.class), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)).retryWhen((Retry)Retry.max((long)1L).filter(arg_0 -> JunoRestClientService.sendPushNotifications$lambda$1((Function1)sendPushNotifications.4.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"retryWhen(...)");
        PushNotificationResults pushNotificationResults = (PushNotificationResults)MonoExtensionsKt.onErrorMap((Mono)mono2, (KClass)Reflection.getOrCreateKotlinClass(ServiceDisabledException.class), (Function1)((Function1)sendPushNotifications.5.INSTANCE)).block();
        if (pushNotificationResults == null) {
            throw new NotFoundException("Juno did not return a result");
        }
        return pushNotificationResults;
    }

    @EventListener
    public final void onLicenseChanged(@NotNull JustLicenseChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.lastServiceDisabledException == null) {
            return;
        }
        LOG.info("Just license changed, retry logging into Juno");
        this.logout();
        this.lastServiceDisabledException = null;
    }

    private final Mono checkServiceNotDisabled() {
        Mono mono = Mono.fromSupplier(() -> JunoRestClientService.checkServiceNotDisabled$lambda$2(this)).flatMap(arg_0 -> JunoRestClientService.checkServiceNotDisabled$lambda$3((Function1)checkServiceNotDisabled.2.INSTANCE, arg_0)).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"ignoreElement(...)");
        return mono;
    }

    private final Mono<JunoOAuth2AccessTokenResponse> getAccessToken() {
        Mono mono = Mono.fromSupplier(() -> JunoRestClientService.getAccessToken$lambda$4(this)).filter(arg_0 -> JunoRestClientService.getAccessToken$lambda$5((Function1)getAccessToken.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"filter(...)");
        return MonoExtensionsKt.switchIfEmpty((Mono)mono, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */));
    }

    private final Mono<JunoOAuth2AccessTokenResponse> login() {
        Mono mono = Mono.fromCallable(() -> JunoRestClientService.login$lambda$6((KMutableProperty0)new /* Unavailable Anonymous Inner Class!! */)).switchIfEmpty(Mono.error((Throwable)((Throwable)new JunoLoginException(JunoLoginException.ErrorCode.LICENSE_NOT_FOUND)))).flatMap(arg_0 -> JunoRestClientService.login$lambda$7((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private final void logout() {
        this.lastAccessToken = null;
    }

    private final void disableServiceIfFatalLicenseError(JunoLoginException error) {
        if (error.isFatalLicenseError()) {
            LOG.info("Received fatal Just license error, stop sending requests to Juno until license is updated");
            this.lastServiceDisabledException = new ServiceDisabledException(error);
        }
    }

    private final Mono<PushNotificationResults> performSendPushNotificationsRequest(List<? extends Object> pushNotifications, JunoOAuth2AccessTokenResponse accessToken) {
        String[] stringArray = new String[]{"application/json"};
        WebClient.RequestHeadersSpec requestHeadersSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/notification", new Object[0])).bodyValue(pushNotifications).header("Content-Type", stringArray);
        stringArray = new String[]{accessToken.getTokenType() + " " + accessToken.getAccessToken()};
        WebClient.ResponseSpec responseSpec = requestHeadersSpec.header("Authorization", stringArray).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), JunoRestClientService::performSendPushNotificationsRequest$lambda$8);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono;
    }

    private final Mono<JunoOAuth2AccessTokenResponse> performLoginRequest(String license) {
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/login", new Object[0])).bodyValue((Object)license).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), JunoRestClientService::performLoginRequest$lambda$10).onStatus(JunoRestClientService::performLoginRequest$lambda$11, JunoRestClientService::performLoginRequest$lambda$12);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono;
    }

    private static final Mono sendPushNotifications$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final boolean sendPushNotifications$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Exception checkServiceNotDisabled$lambda$2(JunoRestClientService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Exception)this$0.lastServiceDisabledException;
    }

    private static final Mono checkServiceNotDisabled$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final JunoOAuth2AccessTokenResponse getAccessToken$lambda$4(JunoRestClientService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.lastAccessToken;
    }

    private static final boolean getAccessToken$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String login$lambda$6(KMutableProperty0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)((Function0)$tmp0).invoke();
    }

    private static final Mono login$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono performSendPushNotificationsRequest$lambda$8(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new JunoUnauthorizedException()));
    }

    private static final JunoLoginException performLoginRequest$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JunoLoginException)$tmp0.invoke(p0);
    }

    private static final Mono performLoginRequest$lambda$10(ClientResponse response) {
        Intrinsics.checkNotNull((Object)response);
        ClientResponse $this$bodyToMono$iv = response;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono.map(arg_0 -> JunoRestClientService.performLoginRequest$lambda$10$lambda$9((Function1)performLoginRequest.2.1.INSTANCE, arg_0));
    }

    private static final boolean performLoginRequest$lambda$11(HttpStatusCode it) {
        return it.isError();
    }

    private static final Mono performLoginRequest$lambda$12(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new JunoLoginException(JunoLoginException.ErrorCode.OTHER)));
    }

    public static final /* synthetic */ Mono access$performSendPushNotificationsRequest(JunoRestClientService $this, List pushNotifications, JunoOAuth2AccessTokenResponse accessToken) {
        return $this.performSendPushNotificationsRequest(pushNotifications, accessToken);
    }

    public static final /* synthetic */ void access$disableServiceIfFatalLicenseError(JunoRestClientService $this, JunoLoginException error) {
        $this.disableServiceIfFatalLicenseError(error);
    }

    public static final /* synthetic */ void access$logout(JunoRestClientService $this) {
        $this.logout();
    }

    public static final /* synthetic */ Mono access$login(JunoRestClientService $this) {
        return $this.login();
    }

    public static final /* synthetic */ void access$setLastAccessToken$p(JunoRestClientService $this, JunoOAuth2AccessTokenResponse junoOAuth2AccessTokenResponse) {
        $this.lastAccessToken = junoOAuth2AccessTokenResponse;
    }

    public static final /* synthetic */ Mono access$performLoginRequest(JunoRestClientService $this, String license) {
        return $this.performLoginRequest(license);
    }
}

