/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.browserpushclient.BrowserPushProducer;
import de.justsoftware.browserpushclient.model.Message;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class BrowserPushService {
    static final String NOTIFICATION_PUSH_TOPIC = "notification";
    private static final Logger LOG = LoggerFactory.getLogger(BrowserPushService.class);
    private final BrowserPushProducer _browserPushProducer;

    @Autowired
    public BrowserPushService(BrowserPushProducer browserPushProducer) {
        this._browserPushProducer = browserPushProducer;
    }

    public void pushNotificationsUpdated(ProfileId receiver) {
        this.pushNotificationsUpdated((Set)ImmutableSet.of((Object)receiver));
    }

    public void pushNotificationsUpdated(Set<ProfileId> receivers) {
        ImmutableSet receiverStrings = (ImmutableSet)receivers.stream().map(ProfileId::toString).collect(ImmutableSet.toImmutableSet());
        try {
            Message message = new Message(NOTIFICATION_PUSH_TOPIC, (Set)receiverStrings, "NOTIFICATIONS_UPDATED", null);
            this._browserPushProducer.dispatchMessage(message);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to send new notification browser push message for receivers: {}\nError: {}", receivers, (Object)e);
        }
    }
}

