/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.graphql.generated.MutationSetSubscriptionArgs;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070\u0015H\u0017R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\"\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00070\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/SubscriptionFetcher;", "", "subscriptionApplicationService", "Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "(Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;)V", "byArticleId", "Lgraphql/schema/DataFetcher;", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "getByArticleId", "()Lgraphql/schema/DataFetcher;", "byArticleWithTitleId", "getByArticleWithTitleId", "byChapterId", "getByChapterId", "byWikiIds", "Ljava/util/concurrent/CompletableFuture;", "getByWikiIds", "setSubscription", "kotlin.jvm.PlatformType", "getSetSubscription", "subscriptionsByWikiDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/WikiId;", "wiki-service"})
public class SubscriptionFetcher {
    @NotNull
    private final SubscriptionApplicationService subscriptionApplicationService;
    @NotNull
    private final DataFetcher<CompletableFuture<SubscriptionDto>> byWikiIds;
    @NotNull
    private final DataFetcher<SubscriptionDto> byChapterId;
    @NotNull
    private final DataFetcher<SubscriptionDto> byArticleId;
    @NotNull
    private final DataFetcher<SubscriptionDto> byArticleWithTitleId;
    @NotNull
    private final DataFetcher<SubscriptionDto> setSubscription;

    @Autowired
    public SubscriptionFetcher(@NotNull SubscriptionApplicationService subscriptionApplicationService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionApplicationService, (String)"subscriptionApplicationService");
        this.subscriptionApplicationService = subscriptionApplicationService;
        this.byWikiIds = SubscriptionFetcher::byWikiIds$lambda$0;
        this.byChapterId = arg_0 -> SubscriptionFetcher.byChapterId$lambda$1(this, arg_0);
        this.byArticleId = arg_0 -> SubscriptionFetcher.byArticleId$lambda$2(this, arg_0);
        this.byArticleWithTitleId = arg_0 -> SubscriptionFetcher.byArticleWithTitleId$lambda$3(this, arg_0);
        this.setSubscription = arg_0 -> SubscriptionFetcher.setSubscription$lambda$4(this, arg_0);
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, SubscriptionDto> subscriptionsByWikiDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.SUBSCRIPTION_LOADER, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public DataFetcher<CompletableFuture<SubscriptionDto>> getByWikiIds() {
        return this.byWikiIds;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getByChapterId() {
        return this.byChapterId;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getByArticleId() {
        return this.byArticleId;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getByArticleWithTitleId() {
        return this.byArticleWithTitleId;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getSetSubscription() {
        return this.setSubscription;
    }

    private static final CompletableFuture byWikiIds$lambda$0(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.SUBSCRIPTION_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final SubscriptionDto byChapterId$lambda$1(SubscriptionFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ChapterDto chapter = (ChapterDto)object2;
        return this$0.subscriptionApplicationService.read(chapter.getId(), context.getAuthContext());
    }

    private static final SubscriptionDto byArticleId$lambda$2(SubscriptionFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ArticleDto article = (ArticleDto)object2;
        return this$0.subscriptionApplicationService.read(article.getId(), context.getAuthContext());
    }

    private static final SubscriptionDto byArticleWithTitleId$lambda$3(SubscriptionFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ArticleWithTitleDto article = (ArticleWithTitleDto)object2;
        return this$0.subscriptionApplicationService.read(article.getId(), context.getAuthContext());
    }

    private static final SubscriptionDto setSubscription$lambda$4(SubscriptionFetcher this$0, DataFetchingEnvironment data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedGraphQLContext ctx = (AuthenticatedGraphQLContext)data.getContext();
        Map map = data.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data.arguments");
        MutationSetSubscriptionArgs args = new MutationSetSubscriptionArgs(map);
        return this$0.subscriptionApplicationService.setSubscription(args.getItemId(), args.isSubscribed(), ctx.getAuthContext());
    }

    public static final /* synthetic */ SubscriptionApplicationService access$getSubscriptionApplicationService$p(SubscriptionFetcher $this) {
        return $this.subscriptionApplicationService;
    }
}

