/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.EmptyTitleOrDescriptionException;
import de.justsoftware.wikiservice.business.exceptions.WikiNotFoundException;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Deletion;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0017J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0014H\u0012J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0016J\"\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0016JR\u0010-\u001a&\u0012\f\u0012\n /*\u0004\u0018\u00010\u00120\u0012 /*\u0012\u0012\f\u0012\n /*\u0004\u0018\u00010\u00120\u0012\u0018\u00010(0.2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010!2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016JZ\u00105\u001a&\u0012\f\u0012\n /*\u0004\u0018\u00010\u00120\u0012 /*\u0012\u0012\f\u0012\n /*\u0004\u0018\u00010\u00120\u0012\u0018\u00010(0.2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010!2\u0006\u00106\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u00107\u001a\b\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J.\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J\u0016\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0!H\u0017J6\u0010=\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010>\u001a\u0004\u0018\u00010\u00142\b\u0010?\u001a\u0004\u0018\u00010\u00142\u0006\u0010@\u001a\u00020\u00172\b\u0010A\u001a\u0004\u0018\u00010\u0017H\u0017R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lde/justsoftware/wikiservice/business/WikiService;", "", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "create", "Lde/justsoftware/wikiservice/business/model/WikiDto;", "title", "", "description", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "contactPerson", "delete", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "findWikisByTenant", "", "Lde/justsoftware/wikiservice/persistence/model/Wiki;", "isNotNullButEmpty", "", "str", "read", "readAll", "", "readAllIds", "readByIds", "", "wikiIds", "readByRoles", "", "kotlin.jvm.PlatformType", "roles", "Lde/justsoftware/permission/client/model/Role;", "page", "", "limit", "readByRolesAndSubscriber", "subscriber", "readByTenant", "readByTenantAndSubscriber", "removeDeletedWikis", "", "deletions", "Lde/justsoftware/wikiservice/persistence/model/Deletion;", "update", "newTitle", "newDescription", "updater", "newContactPerson", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n442#2:223\n392#2:224\n1238#3,4:225\n1549#3:229\n1620#3,3:230\n1603#3,9:233\n1855#3:242\n1856#3:244\n1612#3:245\n1549#3:246\n1620#3,3:247\n1549#3:250\n1620#3,3:251\n1603#3,9:254\n1855#3:263\n1856#3:265\n1612#3:266\n1549#3:267\n1620#3,3:268\n1#4:243\n1#4:264\n*S KotlinDebug\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n*L\n81#1:223\n81#1:224\n81#1:225,4\n86#1:229\n86#1:230,3\n88#1:233,9\n88#1:242\n88#1:244\n88#1:245\n96#1:246\n96#1:247,3\n116#1:250\n116#1:251,3\n208#1:254,9\n208#1:263\n208#1:265\n208#1:266\n216#1:267\n216#1:268,3\n88#1:243\n208#1:264\n*E\n"})
public class WikiService {
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public WikiService(@NotNull WikiRepository wikiRepository, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionService permissionService, @NotNull SubscriptionService subscriptionService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.wikiRepository = wikiRepository;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionService = permissionService;
        this.subscriptionService = subscriptionService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public WikiDto create(@NotNull String title, @NotNull String description, @NotNull ProfileId creator, @NotNull TenantId tenantId, @Nullable ProfileId contactPerson) {
        WikiDto wikiDto;
        void it;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (StringsKt.isBlank((CharSequence)title) || StringsKt.isBlank((CharSequence)description)) {
            throw new EmptyTitleOrDescriptionException();
        }
        Object object = this.wikiRepository.saveAndFlush((Object)new Wiki(((Object)StringsKt.trim((CharSequence)title)).toString(), description, tenantId, creator, null, contactPerson));
        Wiki wiki = (Wiki)object;
        WikiDto.Companion companion = WikiDto.Companion;
        boolean bl = false;
        WikiId wikiId = it.getId();
        if (wikiId == null) {
            throw new WikiNotFoundException(null, 1, null);
        }
        WikiId wikiId2 = wikiId;
        this.permissionService.addPermissionItemForNewWiki(wikiId2, tenantId);
        this.subscriptionService.setSubscription((ItemId)wikiId2, creator, true);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"wikiRepository\n         \u2026ator, true)\n            }");
        WikiDto it2 = wikiDto = companion.toDto((Wiki)object2);
        boolean bl2 = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return wikiDto;
    }

    @Transactional
    @NotNull
    public WikiDto read(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Object object = this.wikiRepository.getReferenceById((Object)wikiId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wikiRepository\n        .getReferenceById(wikiId)");
        return WikiDto.Companion.toDto((Wiki)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, WikiDto> readByIds(@NotNull Set<WikiId> wikiIds) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = this.wikiRepository.findByIds(wikiIds);
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                Wiki wiki = (Wiki)entry2.getValue();
                WikiDto wikiDto = WikiDto.Companion.toDto(wiki);
                map4.put(k, wikiDto);
            }
            map = destination$iv$iv;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiDto> readAll() {
        void $this$mapTo$iv$iv;
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wikiRepository\n        .findAll()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Wiki wiki = (Wiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(WikiDto.Companion.toDto((Wiki)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<WikiId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wikiRepository.findAll()");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WikiId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Wiki it = (Wiki)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public List<WikiDto> readByRoles(@NotNull Set<Role> roles, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void r;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Set set = CollectionsKt.toSet((Iterable)it);
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(page, limit, Sort.by(\u2026.Direction.ASC, \"title\"))");
        return this.wikiRepository.findAllByPermissionRoles(set, tenantId, (Pageable)pageRequest).get().map(arg_0 -> WikiService.readByRoles$lambda$7((Function1)readByRoles.3.INSTANCE, arg_0)).toList();
    }

    /*
     * WARNING - void declaration
     */
    public List<WikiDto> readByRolesAndSubscriber(@NotNull Set<Role> roles, @NotNull ProfileId subscriber, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void r;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Set set = CollectionsKt.toSet((Iterable)it);
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(page, limit, Sort.by(\u2026.Direction.ASC, \"title\"))");
        return this.wikiRepository.findAllByPermissionRolesAndSubscriber(set, tenantId, l, (Pageable)pageRequest).get().map(arg_0 -> WikiService.readByRolesAndSubscriber$lambda$10((Function1)readByRolesAndSubscriber.3.INSTANCE, arg_0)).toList();
    }

    @NotNull
    public Set<Wiki> findWikisByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return CollectionsKt.toSet((Iterable)this.wikiRepository.findAllByTenantId(tenantId));
    }

    @NotNull
    public List<WikiDto> readByTenant(@NotNull TenantId tenantId, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(page, limit, Sort.by(\u2026.Direction.ASC, \"title\"))");
        List list = this.wikiRepository.findAllByTenantId(tenantId, (Pageable)pageRequest).map(arg_0 -> WikiService.readByTenant$lambda$11((Function1)readByTenant.1.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wikiRepository\n        .\u2026Dto() }\n        .toList()");
        return list;
    }

    @NotNull
    public List<WikiDto> readByTenantAndSubscriber(@NotNull TenantId tenantId, @NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(page, limit, Sort.by(\u2026.Direction.ASC, \"title\"))");
        List list = this.wikiRepository.findAllByTenantIdAndSubscriber(tenantId, l, (Pageable)pageRequest).map(arg_0 -> WikiService.readByTenantAndSubscriber$lambda$12((Function1)readByTenantAndSubscriber.1.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wikiRepository\n        .\u2026Dto() }\n        .toList()");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public WikiDto update(@NotNull WikiId wikiId, @Nullable String newTitle, @Nullable String newDescription, @NotNull ProfileId updater, @Nullable ProfileId newContactPerson) {
        WikiDto wikiDto;
        void it;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (this.isNotNullButEmpty(newTitle) || this.isNotNullButEmpty(newDescription)) {
            throw new EmptyTitleOrDescriptionException();
        }
        Wiki wiki = (Wiki)this.wikiRepository.getReferenceById((Object)wikiId);
        WikiDto.Companion companion = WikiDto.Companion;
        boolean bl = false;
        if (newTitle != null) {
            it.setTitle(((Object)StringsKt.trim((CharSequence)newTitle)).toString());
        }
        if (newDescription != null) {
            it.setDescription(newDescription);
        }
        it.setContactPerson(newContactPerson);
        it.setModifiedBy(updater);
        Wiki wiki2 = (Wiki)this.wikiRepository.saveAndFlush((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)wiki2, (String)"wikiRepository\n         \u2026ndFlush(it)\n            }");
        WikiDto it2 = wikiDto = companion.toDto(wiki2);
        boolean bl2 = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return wikiDto;
    }

    private boolean isNotNullButEmpty(String str) {
        return str != null && StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)str)).toString());
    }

    @Transactional
    @NotNull
    public WikiDto delete(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        WikiDto wikiDTO = this.read(wikiId);
        this.articleService.deleteWikiArticles(wikiId, deletionId);
        this.chapterService.deleteWikiChapters(wikiId, deletionId);
        this.permissionService.removePermissionsForDeletedWiki(wikiId);
        this.wikiRepository.deleteById((Object)wikiId, deletionId);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return wikiDTO;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedWikis(@NotNull Set<Deletion> deletions) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletions, (String)"deletions");
        Iterable $this$mapNotNull$iv = deletions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<WikiId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WikiId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Deletion it = (Deletion)element$iv$iv;
            boolean bl2 = false;
            if ((it.getItemType() == IdType.WIKI_WIKI ? new WikiId(it.getItemId()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set wikiIdsToRemovePermissionsFrom = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = deletions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (Deletion)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            DeletionId deletionId = it.getId();
            if (deletionId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(deletionId);
        }
        Set deletionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.permissionService.removePermissionsForWikis(wikiIdsToRemovePermissionsFrom);
        this.wikiRepository.deleteAllByDeletionIds(deletionIds);
    }

    private static final WikiDto readByRoles$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WikiDto)$tmp0.invoke(p0);
    }

    private static final WikiDto readByRolesAndSubscriber$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WikiDto)$tmp0.invoke(p0);
    }

    private static final WikiDto readByTenant$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WikiDto)$tmp0.invoke(p0);
    }

    private static final WikiDto readByTenantAndSubscriber$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WikiDto)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(WikiService $this) {
        return $this.applicationEventPublisher;
    }
}

