/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.TableOfContentsService$update$;
import de.justsoftware.wikiservice.business.UpdateItem;
import de.justsoftware.wikiservice.business.exceptions.ArticleNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.model.TableOfContentsArticleDto;
import de.justsoftware.wikiservice.business.model.TableOfContentsChapterDto;
import de.justsoftware.wikiservice.business.model.TableOfContentsDto;
import de.justsoftware.wikiservice.graphql.generated.UpdateTableOfContentsElementInput;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TableOfContentsElement;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.DeletionFlagModel;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011H\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0012J\u001e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0012J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%2\u0006\u0010\u0017\u001a\u00020\u0012H\u0012J&\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020(0\u001a2\u0006\u0010)\u001a\u00020*H\u0017J,\u0010+\u001a\u00020\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010)\u001a\u00020*H\u0012J:\u0010.\u001a\u00020\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u000e2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000e2\u0006\u0010)\u001a\u00020*H\u0012J\u001c\u00104\u001a\u0004\u0018\u00010\"*\b\u0012\u0004\u0012\u00020\"0%2\u0006\u0010\u0017\u001a\u00020\u0012H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lde/justsoftware/wikiservice/business/TableOfContentsService;", "", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "maxChapterDepth", "", "(Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/business/AncestorService;I)V", "getArticlesForParentIds", "", "Lde/justsoftware/wikiservice/business/model/TableOfContentsArticleDto;", "parentIdsAndLevel", "", "Lde/justsoftware/wikiservice/model/ParentId;", "getChaptersForParentId", "Lde/justsoftware/wikiservice/business/model/TableOfContentsChapterDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "parentId", "getMaxChapterDepth", "items", "", "Lde/justsoftware/wikiservice/business/UpdateItem;", "persistUpdates", "", "itemsToUpdate", "read", "Lde/justsoftware/wikiservice/business/model/TableOfContentsDto;", "readChildrenOfParent", "Lde/justsoftware/wikiservice/model/TableOfContentsElement;", "sortTableOfContentsElementList", "unsortedList", "", "update", "", "Lde/justsoftware/wikiservice/graphql/generated/UpdateTableOfContentsElementInput;", "updater", "Lde/justsoftware/wikiservice/model/ProfileId;", "updateModifiedDate", "chaptersToUpdate", "articlesToUpdate", "updatePositionAndPersist", "allSitemapItems", "allArticles", "Lde/justsoftware/wikiservice/persistence/model/Article;", "allChapters", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "popNextNodeOrNull", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTableOfContentsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableOfContentsService.kt\nde/justsoftware/wikiservice/business/TableOfContentsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,342:1\n1549#2:343\n1620#2,3:344\n766#2:347\n857#2,2:348\n1549#2:350\n1620#2,3:351\n1603#2,9:354\n1855#2:363\n1856#2:365\n1612#2:366\n1603#2,9:367\n1855#2:376\n1856#2:378\n1612#2:379\n1549#2:380\n1620#2,3:381\n766#2:384\n857#2,2:385\n2333#2,14:387\n1549#2:402\n1620#2,3:403\n1194#2,2:406\n1222#2,4:408\n1194#2,2:412\n1222#2,4:414\n1045#2:418\n1855#2:419\n288#2,2:420\n288#2,2:422\n1856#2:424\n1477#2:425\n1502#2,3:426\n1505#2,3:436\n1549#2:439\n1620#2,2:440\n1559#2:442\n1590#2,4:443\n1622#2:447\n766#2:448\n857#2:449\n288#2,2:450\n288#2,2:452\n858#2:454\n1855#2,2:455\n1603#2,9:457\n1855#2:466\n1856#2:468\n1612#2:469\n1603#2,9:470\n1855#2:479\n1856#2:481\n1612#2:482\n1549#2:483\n1620#2,3:484\n1549#2:487\n1620#2,3:488\n766#2:491\n857#2,2:492\n1549#2:494\n1620#2,3:495\n288#2,2:498\n1#3:364\n1#3:377\n1#3:401\n1#3:467\n1#3:480\n361#4,7:429\n*S KotlinDebug\n*F\n+ 1 TableOfContentsService.kt\nde/justsoftware/wikiservice/business/TableOfContentsService\n*L\n57#1:343\n57#1:344,3\n75#1:347\n75#1:348,2\n76#1:350\n76#1:351,3\n77#1:354,9\n77#1:363\n77#1:365\n77#1:366\n87#1:367,9\n87#1:376\n87#1:378\n87#1:379\n89#1:380\n89#1:381,3\n116#1:384\n116#1:385,2\n117#1:387,14\n128#1:402\n128#1:403,3\n131#1:406,2\n131#1:408,4\n133#1:412,2\n133#1:414,4\n137#1:418\n143#1:419\n147#1:420,2\n157#1:422,2\n143#1:424\n207#1:425\n207#1:426,3\n207#1:436,3\n209#1:439\n209#1:440,2\n210#1:442\n210#1:443,4\n209#1:447\n213#1:448\n213#1:449\n217#1:450,2\n233#1:452,2\n213#1:454\n259#1:455,2\n288#1:457,9\n288#1:466\n288#1:468\n288#1:469\n295#1:470,9\n295#1:479\n295#1:481\n295#1:482\n301#1:483\n301#1:484,3\n307#1:487\n307#1:488,3\n326#1:491\n326#1:492,2\n328#1:494\n328#1:495,3\n195#1:498,2\n77#1:364\n87#1:377\n288#1:467\n295#1:480\n207#1:429,7\n*E\n"})
public class TableOfContentsService {
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final AncestorService ancestorService;
    private final int maxChapterDepth;

    @Autowired
    public TableOfContentsService(@NotNull ArticleRepository articleRepository, @NotNull ArticleVersionRepository articleVersionRepository, @NotNull ChapterRepository chapterRepository, @NotNull AncestorService ancestorService, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth) {
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        this.articleRepository = articleRepository;
        this.articleVersionRepository = articleVersionRepository;
        this.chapterRepository = chapterRepository;
        this.ancestorService = ancestorService;
        this.maxChapterDepth = maxChapterDepth;
    }

    @NotNull
    public TableOfContentsDto read(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        return new TableOfContentsDto(wikiId, parentId, this.maxChapterDepth, this.readChildrenOfParent(wikiId, parentId));
    }

    /*
     * WARNING - void declaration
     */
    private List<TableOfContentsElement> readChildrenOfParent(WikiId wikiId, ParentId parentId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set chapters = this.getChaptersForParentId(wikiId, parentId);
        Iterable iterable = chapters;
        TableOfContentsService tableOfContentsService = this;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TableOfContentsChapterDto tableOfContentsChapterDto = (TableOfContentsChapterDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getId(), (Object)it.getLevel()));
        }
        Set articles = tableOfContentsService.getArticlesForParentIds(MapsKt.plus((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)parentId, (Object)-1))));
        return this.sortTableOfContentsElementList(CollectionsKt.toMutableList((Collection)SetsKt.plus((Set)chapters, (Iterable)articles)), parentId);
    }

    /*
     * WARNING - void declaration
     */
    private Set<TableOfContentsChapterDto> getChaptersForParentId(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        int level = 0;
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Chapter it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Chapter)element$iv$iv;
                boolean bl = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            $this$filter$iv = children;
            Set set = result;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Chapter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TableOfContentsChapterDto.Companion.toTableOfContentsChapterDto(it, level));
            }
            set.addAll((List)destination$iv$iv);
            Iterable $this$mapNotNull$iv = children;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UUID it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Chapter it2 = (Chapter)element$iv$iv;
                boolean bl2 = false;
                ChapterId chapterId = it2.getId();
                if ((chapterId != null ? chapterId.getId() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            int n = level;
            level = n + 1;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Set<TableOfContentsArticleDto> getArticlesForParentIds(Map<ParentId, Integer> parentIdsAndLevel) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Map articles = this.articleRepository.findByParentIds(parentIdsAndLevel.keySet());
        Iterable iterable = CollectionsKt.flatten((Iterable)articles.values());
        Object object = this.articleVersionRepository;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Article article = $this$forEach$iv$iv$iv.iterator();
        while (article.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = article.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map articleVersions = object.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Iterable $this$map$iv = CollectionsKt.flatten((Iterable)articles.values());
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleVersion articleVersion;
            ArticleId id;
            void it;
            article = (Article)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            if (it.getId() == null) {
                throw new ArticleNotFoundException(null, 1, null);
            }
            if ((ArticleVersion)articleVersions.get(id) == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            Integer n = parentIdsAndLevel.get(IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType()));
            if (n == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            object.add(TableOfContentsArticleDto.Companion.toTableOfContentsArticleDto((Article)it, articleVersion, ((Number)n).intValue() + 1));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private List<TableOfContentsElement> sortTableOfContentsElementList(List<TableOfContentsElement> unsortedList, ParentId parentId) {
        List result = new ArrayList();
        TableOfContentsElement next = this.popNextNodeOrNull(unsortedList, parentId);
        while (next != null) {
            result.add(next);
            if (next instanceof TableOfContentsChapterDto) {
                result.addAll(this.sortTableOfContentsElementList(unsortedList, (ParentId)((TableOfContentsChapterDto)next).getId()));
            }
            next = this.popNextNodeOrNull(unsortedList, parentId);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private TableOfContentsElement popNextNodeOrNull(List<TableOfContentsElement> $this$popNextNodeOrNull, ParentId parentId) {
        TableOfContentsElement tableOfContentsElement;
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$popNextNodeOrNull;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TableOfContentsElement it = (TableOfContentsElement)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getParentId(), (Object)parentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                TableOfContentsElement it = (TableOfContentsElement)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getRelativePosition();
                do {
                    Object e$iv = iterator$iv.next();
                    TableOfContentsElement it2 = (TableOfContentsElement)e$iv;
                    $i$a$-minByOrNull-TableOfContentsService$popNextNodeOrNull$2 = false;
                    int v$iv = it2.getRelativePosition();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        TableOfContentsElement tableOfContentsElement2 = v0;
        if (tableOfContentsElement2 != null) {
            TableOfContentsElement tableOfContentsElement3;
            TableOfContentsElement it = tableOfContentsElement3 = tableOfContentsElement2;
            boolean bl = false;
            $this$popNextNodeOrNull.remove(it);
            tableOfContentsElement = tableOfContentsElement3;
        } else {
            tableOfContentsElement = null;
        }
        return tableOfContentsElement;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean update(@NotNull WikiId wikiId, @NotNull List<UpdateTableOfContentsElementInput> items, @NotNull ProfileId updater) {
        void $this$forEach$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateByTo$iv$iv2;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator item;
            UpdateTableOfContentsElementInput updateTableOfContentsElementInput = (UpdateTableOfContentsElementInput)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new UpdateItem(item.getId(), item.getParentId(), null, false, 12, null));
        }
        List allSitemapItems = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$associateBy$iv = this.articleRepository.findAllByWikiId(wikiId);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            Article article = (Article)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            ArticleId articleId = it.getId();
            if (articleId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            object.put(articleId, element$iv$iv);
        }
        Map allArticles = destination$iv$iv2;
        Iterable $this$associateBy$iv2 = this.chapterRepository.findAllByWikiId(wikiId);
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Chapter bl = (Chapter)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl2 = false;
            ChapterId chapterId = it.getId();
            if (chapterId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            object.put(chapterId, element$iv$iv);
        }
        Map allChapters = destination$iv$iv3;
        Iterable $this$sortedBy$iv = CollectionsKt.plus(allArticles.values(), (Iterable)allChapters.values());
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new update$$inlined$sortedBy$1()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object2;
            Object v4;
            ArticleId id;
            DeletionFlagModel it;
            block13: {
                UpdateTableOfContentsElementInput item;
                Object element$iv2;
                Iterator iterator;
                boolean $i$f$firstOrNull;
                Object $this$firstOrNull$iv;
                it = (DeletionFlagModel)element$iv;
                boolean bl = false;
                DeletionFlagModel deletionFlagModel = it;
                if (deletionFlagModel instanceof Article) {
                    Object object3;
                    Object v2;
                    block12: {
                        if (((Article)it).getId() == null) {
                            Object element$iv$iv;
                            element$iv$iv = "Required value was null.";
                            throw new IllegalStateException(element$iv$iv.toString());
                        }
                        $this$firstOrNull$iv = items;
                        $i$f$firstOrNull = false;
                        iterator = $this$firstOrNull$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv2 = iterator.next();
                            item = (UpdateTableOfContentsElementInput)element$iv2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)item.getId(), (Object)id)) continue;
                            v2 = element$iv2;
                            break block12;
                        }
                        v2 = null;
                    }
                    if ((object3 = (UpdateTableOfContentsElementInput)v2) != null) continue;
                    object3 = allSitemapItems.add(new UpdateItem((ItemId)id, IdUtilsKt.parentIdOf((UUID)((Article)it).getParentId(), (IdType)((Article)it).getParentType()), null, it.getDeletionId() != null, 4, null));
                    continue;
                }
                if (!(deletionFlagModel instanceof Chapter)) continue;
                if (((Chapter)it).getId() == null) {
                    $this$firstOrNull$iv = "Required value was null.";
                    throw new IllegalStateException($this$firstOrNull$iv.toString());
                }
                $this$firstOrNull$iv = items;
                $i$f$firstOrNull = false;
                iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv2 = iterator.next();
                    item = (UpdateTableOfContentsElementInput)element$iv2;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)item.getId(), (Object)id)) continue;
                    v4 = element$iv2;
                    break block13;
                }
                v4 = null;
            }
            if ((object2 = (UpdateTableOfContentsElementInput)v4) != null) continue;
            object2 = allSitemapItems.add(new UpdateItem((ItemId)id, IdUtilsKt.parentIdOf((UUID)((Chapter)it).getParentId(), (IdType)((Chapter)it).getParentType()), null, it.getDeletionId() != null, 4, null));
        }
        int newMaxChapterDepth = this.getMaxChapterDepth(wikiId, allSitemapItems);
        if (!(newMaxChapterDepth <= this.maxChapterDepth)) {
            boolean bl = false;
            String string = "Maximum chapter depth exceeded (" + newMaxChapterDepth + " > " + this.maxChapterDepth + ").";
            throw new IllegalStateException(string.toString());
        }
        this.updatePositionAndPersist(allSitemapItems, CollectionsKt.toSet((Iterable)allArticles.values()), CollectionsKt.toSet((Iterable)allChapters.values()), updater);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void updatePositionAndPersist(List<UpdateItem> allSitemapItems, Set<Article> allArticles, Set<Chapter> allChapters, ProfileId updater) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list$iv$iv;
        UpdateItem it;
        void $this$groupByTo$iv$iv;
        Set modifiedChapters = new LinkedHashSet();
        Set modifiedArticles = new LinkedHashSet();
        Iterable $this$groupBy$iv = allSitemapItems;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (UpdateItem)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = it.getParentId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv;
            list$iv$iv = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Iterable $this$mapIndexed$iv = (Iterable)it;
            boolean $i$f$mapIndexed = false;
            Iterable $i$f$getOrPut = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void index;
                void item;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                UpdateItem updateItem = (UpdateItem)item$iv$iv2;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(UpdateItem.copy$default((UpdateItem)item, null, null, (Integer)((int)index), (boolean)false, (int)11, null));
            }
            object.add((List)destination$iv$iv2);
        }
        $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            UpdateItem item = (UpdateItem)element$iv$iv;
            boolean bl4 = false;
            ItemId itemId = item.getId();
            if (itemId instanceof ArticleId) {
                Article article;
                Object v1;
                block23: {
                    $this$firstOrNull$iv = allArticles;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (Article)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)item.getId())) continue;
                        v1 = element$iv;
                        break block23;
                    }
                    v1 = null;
                }
                if ((Article)v1 == null) {
                    bl = false;
                } else if (!Intrinsics.areEqual((Object)item.getParentId().getId(), (Object)article.getParentId())) {
                    modifiedArticles.add(item);
                    if (TableOfContentsService.updatePositionAndPersist$getParentChapterIfPresent(allChapters, (UUID)article.getParentId()) != null) {
                        UpdateItem it2;
                        boolean bl6 = false;
                        modifiedChapters.add(it2);
                    }
                    bl = true;
                } else {
                    bl = !Intrinsics.areEqual((Object)item.getRelativePosition(), (Object)article.getRelativePosition());
                }
            } else if (itemId instanceof ChapterId) {
                Chapter chapter;
                Object v3;
                block24: {
                    $this$firstOrNull$iv = allChapters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (Chapter)element$iv;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)item.getId())) continue;
                        v3 = element$iv;
                        break block24;
                    }
                    v3 = null;
                }
                if ((Chapter)v3 == null) {
                    bl = false;
                } else if (!Intrinsics.areEqual((Object)item.getParentId().getId(), (Object)chapter.getParentId())) {
                    modifiedChapters.add(item);
                    if (TableOfContentsService.updatePositionAndPersist$getParentChapterIfPresent(allChapters, (UUID)chapter.getParentId()) != null) {
                        UpdateItem it3;
                        boolean bl8 = false;
                        modifiedChapters.add(it3);
                    }
                    bl = true;
                } else {
                    bl = !Intrinsics.areEqual((Object)item.getRelativePosition(), (Object)chapter.getRelativePosition());
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List itemsToUpdate = (List)destination$iv$iv;
        this.persistUpdates(itemsToUpdate);
        this.updateModifiedDate(modifiedChapters, modifiedArticles, updater);
    }

    private void persistUpdates(List<UpdateItem> itemsToUpdate) {
        Iterable $this$forEach$iv = itemsToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UpdateItem item = (UpdateItem)element$iv;
            boolean bl = false;
            ItemId itemId = item.getId();
            if (itemId instanceof ArticleId) {
                ArticleRepository articleRepository = this.articleRepository;
                UUID uUID = item.getParentId().getId();
                IdType idType = item.getParentId().type();
                Integer n = item.getRelativePosition();
                if (n == null) {
                    IdType idType2 = idType;
                    UUID uUID2 = uUID;
                    ArticleRepository articleRepository2 = articleRepository;
                    boolean $i$a$-checkNotNull-TableOfContentsService$persistUpdates$1$32 = false;
                    String string = "relativePosition must not be null";
                    ArticleRepository articleRepository3 = articleRepository2;
                    UUID uUID3 = uUID2;
                    IdType idType3 = idType2;
                    String $i$a$-checkNotNull-TableOfContentsService$persistUpdates$1$32 = string;
                    throw new IllegalStateException($i$a$-checkNotNull-TableOfContentsService$persistUpdates$1$32.toString());
                }
                articleRepository.updateParentIdAndPosition(uUID, idType, ((Number)n).intValue(), (ArticleId)item.getId());
                continue;
            }
            if (!(itemId instanceof ChapterId)) continue;
            ChapterRepository chapterRepository = this.chapterRepository;
            UUID uUID = item.getParentId().getId();
            IdType idType = item.getParentId().type();
            Integer n = item.getRelativePosition();
            if (n == null) {
                IdType idType4 = idType;
                UUID uUID4 = uUID;
                ChapterRepository chapterRepository2 = chapterRepository;
                boolean bl2 = false;
                String string = "relativePosition must not be null";
                ChapterRepository chapterRepository3 = chapterRepository2;
                UUID uUID5 = uUID4;
                IdType idType5 = idType4;
                String string2 = string;
                throw new IllegalStateException(string2.toString());
            }
            chapterRepository.updateParentIdAndPosition(uUID, idType, ((Number)n).intValue(), (ChapterId)item.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateModifiedDate(Set<UpdateItem> chaptersToUpdate, Set<UpdateItem> articlesToUpdate, ProfileId updater) {
        UpdateItem it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv$iv$iv22;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Instant updatedAt = Instant.now();
        Iterable iterable = chaptersToUpdate;
        boolean $i$f$mapNotNull22 = false;
        void var8_8 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv22 : $this$forEach$iv$iv$iv) {
            ChapterId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv22;
            boolean bl = false;
            UpdateItem it2 = (UpdateItem)element$iv$iv;
            boolean bl2 = false;
            if ((it2.getId() instanceof ChapterId ? (ChapterId)it2.getId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set modifiedChapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)modifiedChapters).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)updatedAt, (String)"updatedAt");
            this.chapterRepository.setUpdatedStatus(modifiedChapters, updater, updatedAt);
        }
        Iterable $i$f$mapNotNull22 = articlesToUpdate;
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv22 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv22.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv22.next();
            boolean bl = false;
            UpdateItem it3 = (UpdateItem)element$iv$iv;
            boolean bl4 = false;
            if ((it3.getId() instanceof ArticleId ? (ArticleId)it3.getId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set modifiedArticles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (!((Collection)modifiedArticles).isEmpty()) {
            void $this$map$iv;
            Iterable $i$f$mapNotNull3 = this.articleVersionRepository.findLatestArticleVersionsByArticleIds(modifiedArticles).values();
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv$iv$iv = (ArticleVersion)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                ArticleVersionId articleVersionId = it.getId();
                if (articleVersionId == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                collection.add(articleVersionId);
            }
            Set articleVersions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            Intrinsics.checkNotNullExpressionValue((Object)updatedAt, (String)"updatedAt");
            this.articleVersionRepository.setModifiedStatus(articleVersions, updater, updatedAt);
        }
        Iterable $this$map$iv = SetsKt.plus(chaptersToUpdate, (Iterable)articlesToUpdate);
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UpdateItem)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.getParentId());
        }
        Set parentIdsToUpdate = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        if (!((Collection)parentIdsToUpdate).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)updatedAt, (String)"updatedAt");
            this.ancestorService.updateEditedStatusForAncestors(parentIdsToUpdate, updatedAt, updater);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxChapterDepth(WikiId wikiId, List<UpdateItem> items) {
        int level = 0;
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)wikiId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            void $this$mapTo$iv$iv;
            UpdateItem it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = items;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UpdateItem)element$iv$iv;
                boolean bl = false;
                if (!(nextParentIds.contains(it.getParentId().getId()) && it.getId() instanceof ChapterId && !it.isDeleted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            result.addAll(children);
            Iterable $this$map$iv = children;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (UpdateItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId().getId());
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            ++level;
        }
        return level - 1;
    }

    private static final UpdateItem updatePositionAndPersist$getParentChapterIfPresent(Set<Chapter> $allChapters, UUID parentId) {
        UpdateItem updateItem;
        Object v1;
        block4: {
            Iterable $this$firstOrNull$iv = $allChapters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Chapter it = (Chapter)element$iv;
                boolean bl = false;
                ChapterId chapterId = it.getId();
                if (!Intrinsics.areEqual((Object)parentId, (Object)(chapterId != null ? chapterId.getId() : null))) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Chapter chapter = v1;
        if (chapter != null) {
            Chapter it = chapter;
            boolean bl = false;
            ChapterId chapterId = it.getId();
            if (chapterId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            updateItem = new UpdateItem((ItemId)chapterId, IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType()), null, false, 12, null);
        } else {
            updateItem = null;
        }
        return updateItem;
    }
}

