/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.authorization;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import de.justsoftware.permission.client.kafka.PermissionConfigNotAvailableException;
import de.justsoftware.permission.client.kafka.PermissionConfigProducer;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.Producer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0001\u0012\u0016\b\u0001\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007H\u0016\u00a8\u0006\b"}, d2={"Lde/justsoftware/wikiservice/authorization/PermissionConfigPublisher;", "Lde/justsoftware/permission/client/kafka/PermissionConfigProducer;", "producer", "Lorg/apache/kafka/clients/producer/Producer;", "", "(Lorg/apache/kafka/clients/producer/Producer;)V", "getConfig", "Lcom/google/common/collect/ImmutableMap;", "wiki-service"})
public class PermissionConfigPublisher
extends PermissionConfigProducer {
    @Autowired
    public PermissionConfigPublisher(@Qualifier(value="KAFKA_STRING_PRODUCER") @Nullable Producer<String, String> producer) {
        super(producer);
    }

    @NotNull
    public ImmutableMap<String, String> getConfig() throws PermissionConfigNotAvailableException {
        try {
            String config = Resources.toString((URL)Resources.getResource((String)"wiki-permission-config.json"), (Charset)Charsets.UTF_8);
            ImmutableMap immutableMap = ImmutableMap.of((Object)"WIKI_WIKI", (Object)config);
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(\"WIKI_WIKI\", config)");
            return immutableMap;
        }
        catch (IOException e) {
            throw new PermissionConfigNotAvailableException("wiki-permission-config.json could not be loaded", (Throwable)e);
        }
    }
}

