/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "(Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "isManager", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "user", "Lde/justsoftware/wikiservice/model/ProfileId;", "isWriter", "mayReadArticleVersionHistory", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
public class UserInfoApplicationService {
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public UserInfoApplicationService(@NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.authorizationService = authorizationService;
    }

    @NotNull
    public Map<WikiId, Boolean> isManager(@NotNull List<WikiId> wikiIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return wikiIds.isEmpty() ? MapsKt.emptyMap() : this.authorizationService.mayManageWikis(CollectionsKt.toSet((Iterable)wikiIds), user);
    }

    @NotNull
    public Map<WikiId, Boolean> isWriter(@NotNull List<WikiId> wikiIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return wikiIds.isEmpty() ? MapsKt.emptyMap() : this.authorizationService.mayWriteWikis(CollectionsKt.toSet((Iterable)wikiIds), user);
    }

    @NotNull
    public Map<WikiId, Boolean> mayReadArticleVersionHistory(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return wikiIds.isEmpty() ? MapsKt.emptyMap() : this.authorizationService.mayReadArticleVersionHistory(CollectionsKt.toSet((Iterable)wikiIds), authContext.getUser(), authContext.getTenantId());
    }
}

