/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.model.ProfileDto;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.ProfileStatus;
import de.justsoftware.wikiservice.model.TenantId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/wikiservice/application/ProfileApplicationService;", "", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "(Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "readByIds", "", "Lde/justsoftware/wikiservice/model/ProfileId;", "Lde/justsoftware/wikiservice/business/model/ProfileDto;", "profiles", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nProfileApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/wikiservice/application/ProfileApplicationService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n442#2:38\n392#2:39\n1238#3,4:40\n*S KotlinDebug\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/wikiservice/application/ProfileApplicationService\n*L\n20#1:38\n20#1:39\n20#1:40,4\n*E\n"})
public class ProfileApplicationService {
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public ProfileApplicationService(@NotNull ProfileService profileService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.profileService = profileService;
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ProfileDto> readByIds(@NotNull Set<ProfileId> profiles, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        Map $this$mapValues$iv = this.profileService.readByIds(profiles);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            ProfileDto profileDto = this.authorizationService.mayProfileReadTenant(tenantId, (ProfileId)it.getKey()) ? (ProfileDto)it.getValue() : new ProfileDto((ProfileId)it.getKey(), ((ProfileDto)it.getValue()).getFullName(), ProfileStatus.DELETED, null, 8, null);
            map3.put(k, profileDto);
        }
        return destination$iv$iv;
    }
}

