// Define global variables for JSLint
/*global CKEDITOR */

//'use strict'; strict mode leads to JUST-11126

CKEDITOR.plugins.add(
    'jc_file', {
        lang: 'de,en',
        icons: 'file',
        hidpi: true,
        init: function(editor) {
            if(typeof window.just.drive === 'undefined'
               || typeof window.just.drive.DriveUploadApp === 'undefined') {
                   // no Drive, no upload
                return;
            }
            var app = null;
            var container = document.createElement("div");
            document.body.appendChild(container);

            function escape(s) {
                return s
                    .replace(/&/g, "&amp;")
                    .replace(/</g, "&lt;")
                    .replace(/>/g, "&gt;")
                    .replace(/"/g, "&quot;");
            }

            function loadAndRenderApp(callback) {
                if (app !== null) {
                    callback();
                } else {
                    app = new window.just.drive.DriveUploadApp();
                    app.addReadyHandler(callback);
                    app.render(container, {itemId:editor.justConnect.entityId});
                }
            }

            // Register the command.
            editor.addCommand('file', {
                exec: function(editor) {
                    loadAndRenderApp(function() {
                        app.upload(function(ev) {
                            // upload started
                        }, function(ev) {
                            var elem = CKEDITOR.dom.element.createFromHtml("<div class=\"file\"><a href=\"#" + editor.justConnect.tokenizeContentId("DRIVE_DOCUMENT,"+ev.fileId) + "\"><img src=\"" + ev.iconUrl + "\" />" + escape(ev.file.name) + "</a></div>");
                            editor.insertElement(elem);
                        }, function(ev) {
                            // upload complete
                        });
                    });
                }
            });

            // Register the toolbar button.
            editor.ui.addButton && editor.ui.addButton('File', {
                label: editor.lang.jc_file.file,
                command: 'file'
            });

            editor.on('beforeDestroy', function(ev) {
                if (app !== null) {
                    app.remove();
                }
                document.body.removeChild(container);
            });
        }
    });
