<#-- Macro for one row in the info block -->
<#macro inforow label value userValue=false>
    <div class="info-row">
        <div class="info-label">${label?html}:</div>
        <div class="info-value <#if userValue>user-value</#if>">${value?html}</div>
    </div>
</#macro>

<#macro htmlEditor title content>
    <div class="editor" role="main">
        <div class="editor-title">${title?html}</div>
        <div class="editor-content userGeneratedHTML">${content}</div>
    </div>
</#macro>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
        <title>${title?html}</title>
        
        <link rel="shortcut icon" href="${favIconUrl}" type="${favIconImageType}">
        <link rel="icon" href="${favIconUrl}" type="${favIconImageType}">
        <link rel="apple-touch-icon" href="/apple-touch-icon.png">
        <link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon-76x76.png">
        <link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120.png">
        <link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152.png">
        <link rel="stylesheet" href="${styleResource}">
        <script src="${jsResource}"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                rewriteLinks('${basePath}');
            });
        </script>
    </head>
    <body class="entity-print-preview">
    <#--               -->
    <#-- Error message -->
    <#--               -->
    <#if errorMessage??>
        <h1>${title?html}</h1>
        ${errorMessage?html}
    <#else>
        <#-- This content will NOT be printed -->
        <div class="header non-printable-content">${labels.header?html}</div>
        <#--                                          -->
        <#-- Content that will be printed starts here -->
        <#--                                          -->
        <div class="printable-content">
            <#--            -->
            <#-- Info block -->
            <#--            -->
            <div class="info" role="contentinfo">
                <#-- URL -->
                <div class="info-row">
                    <div class="info-label">
                        <#-- div was left for compatibility, as the logo does not exists anymore  -->
                    </div>
                    <div class="info-value vcentered">
                        ${labels.printPreviewOf?html} <a href="${info.url}">${info.url}</a>
                    </div>
                </div>
                <#-- name -->
                <div class="info-row">
                    <div class="info-label">${labels.title?html}:</div>
                    <h1 class="info-value">${info.name?html}</h1>
                </div>
                <#-- duration and location of entities with duration activated (appointments and such) -->
                <#if info.duration??>
                    <@inforow label=labels.duration value=info.duration/>
                    <#if info.location?has_content>
                        <@inforow label=labels.location value=info.location/>
                    </#if>
                </#if>
                <#-- old style release process info -->
                <#if info.version??>
                    <@inforow label=labels.version value="${info.version.type} ${info.version.number}"/>
                    <#if (info.version.releaseDate?? || info.version.expirationDate??) && !info.version.declined>
                        <div class="info-row">
                            <div class="info-label">
                                <#if info.version.releaseDate??>
                                    ${labels.releaseDate?html}:
                                </#if>
                                <#if info.version.releaseDate?? && info.version.expirationDate??>
                                    <br>
                                </#if>
                                <#if info.version.expirationDate??>
                                    ${labels.expirationDate?html}:
                                </#if>
                            </div>
                            <div class="info-value">
                                <#if info.version.releaseDate??>
                                    ${info.version.releaseDate?html}
                                </#if>
                                <#if info.version.releaseDate?? && info.version.expirationDate??>
                                    <br>
                                </#if>
                                <#if info.version.expirationDate??>
                                    ${info.version.expirationDate?html}
                                </#if>
                            </div>
                        </div>
                    </#if>
                </#if>
                <#-- new style process info -->
                <#if info.processStatus??>
                    <@inforow label=labels.processStatus value=info.processStatus.status/>
                    <@inforow label=labels.processAssignee value=info.processStatus.assignee/>
                </#if>
                <#-- Tags -->
                <#if info.tags?has_content>
                    <@inforow label=labels.tags value=info.tags/>
                </#if>
                <#-- assigned entities -->
                <#if info.assignedEntities??>
                    <div class="info-row">
                        <div class="info-label">${labels.assignedEntities?html}:</div>
                        <div class="info-value">
                            <#list info.assignedEntities as assignedEntity><#if assignedEntity.url??><a href="${assignedEntity.url}">${assignedEntity.label}</a><#else>${assignedEntity.label}</#if><#if assignedEntity_has_next>, </#if></#list>
                        </div>
                    </div>
                </#if>
                <#-- admins -->
                <#if info.admins??>
                    <div class="info-row">
                        <div class="info-label">${labels.admins?html}:</div>
                        <div class="info-value">
                            <#list info.admins as profile><#if profile.url??><a href="${profile.url}">${profile.label}</a><#else>${profile.label}</#if><#if profile_has_next>, </#if></#list>
                        </div>
                    </div>
                </#if>
                <#if info.coAdmins??>
                    <div class="info-row">
                        <div class="info-label">${labels.coAdmins?html}:</div>
                        <div class="info-value">
                            <#list info.coAdmins as profile><#if profile.url??><a href="${profile.url}">${profile.label}</a><#else>${profile.label}</#if><#if profile_has_next>, </#if></#list>
                        </div>
                    </div>
                </#if>
                <#if info.inheritedCoAdmins??>
                    <div class="info-row">
                        <div class="info-label">${labels.inheritedCoAdmins?html}:</div>
                        <div class="info-value">
                            <#list info.inheritedCoAdmins as profile><#if profile.url??><a href="${profile.url}">${profile.label}</a><#else>${profile.label}</#if><#if profile_has_next>, </#if></#list>
                        </div>
                    </div>
                </#if>
                <#-- dynamic attributes -->
                <#list info.attributes as attribute>
                    <@inforow label=attribute.label value=attribute.value userValue=true/>
                </#list>
            </div>
            <#--            -->
            <#-- Editors    -->
            <#--            -->
            
            <#-- Multi-Wiki -->
            <#if multiWiki??>
                <div class="editor">
                    <#if multiWiki.viewedAs?has_content>
                        <div class="editor-viewed-as">${multiWiki.viewedAs}</div>
                    </#if>
                    <#list multiWiki.sections as section>
                        <div class="editor-section" role="main">
                            <div class="editor-title">${section.title}</div>
                            <#if section.visibility?has_content>
                                <div class="section-visibility">${section.visibility}</div>
                            </#if>
                            <div class="editor-content userGeneratedHTML">${section.content}</div>
                        </div>
                    </#list>
                </div>
            </#if>
            <#-- Wiki -->
            <#if wiki??>
                <@htmlEditor title=wiki.title content=wiki.content/>
            </#if>
            <#-- Info-Widget -->
            <#if infoWidget??>
                <@htmlEditor title=infoWidget.title content=infoWidget.content/>
            </#if>
            <#-- Raw Editors -->
            <#if rawEditors??>
                <#list rawEditors as rawEditor>
                    <@htmlEditor title=rawEditor.title content=rawEditor.content/>
                </#list>
            </#if>
        </div>
    </#if>
    </body>
</html>
