/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.web.design;

import de.justsoftware.onx.design.business.ThemeReadDataService;
import de.justsoftware.onx.design.shared.model.Theme;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.Transformer;

@ParametersAreNonnullByDefault
@Service(value="themeGroupProvider")
public class JucoThemeGroupProvider
implements Transformer<WroModel> {
    private final ThemeReadDataService _themeReadService;

    @Autowired
    public JucoThemeGroupProvider(ThemeReadDataService themeDataService) {
        this._themeReadService = themeDataService;
    }

    public WroModel transform(WroModel input) {
        Theme defaultTheme = this._themeReadService.getDefaultTheme();
        Group themeGroup = new Group("theme-" + defaultTheme.getId().getId());
        input.addGroup(themeGroup);
        themeGroup.addResource(Resource.create((String)"classpath:static/less/juco/mixins/theme.less", (ResourceType)ResourceType.CSS));
        themeGroup.addResource(Resource.create((String)("theme:" + defaultTheme.getId().getId()), (ResourceType)ResourceType.CSS));
        return input;
    }
}

