/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.github.gwtbootstrap.client.ui.Column;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.JucoIconTypes;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediator;
import de.justsoftware.onx.wikieditor.presentation.client.WikiVersionsHandler;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiVersionsWidget;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorConstants;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorMessages;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionTeaser;
import javax.annotation.Nonnull;

public class WikiVersionBadgeWidget
extends Row {
    private static final String VERSION1_GROUP = "version1Group";
    private static final String VERSION2_GROUP = "version2Group";
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private static final WikiEditorConstants WIKI_EDITOR = I18nMediator.WIKI_EDITOR;
    private static final WikiEditorMessages WIKI_EDITOR_MSG = I18nMediator.WIKI_EDITOR_MSG;
    final WikiVersionsWidget _parent;
    final WikiVersionBadge _version;
    final RadioButton _versionSelect1 = new RadioButton("version1Group");
    final RadioButton _versionSelect2 = new RadioButton("version2Group");
    final ClickHandler _restoreClickHandler = new /* Unavailable Anonymous Inner Class!! */;
    final ClickHandler _deleteClickHandler = new /* Unavailable Anonymous Inner Class!! */;

    public WikiVersionBadgeWidget(@Nonnull WikiVersionsWidget parent, @Nonnull WikiVersionBadge wikiPageVersion, @Nonnull ClientFactory clientFactory) {
        boolean isCurrentVersion;
        this._parent = parent;
        this._version = wikiPageVersion;
        this.addStyleName("version-row");
        Column versionColumn = new Column(1);
        this._versionSelect1.addStyleName("pull-left");
        this._versionSelect2.addStyleName("pull-left");
        versionColumn.add((Widget)this._versionSelect2);
        versionColumn.add((Widget)this._versionSelect1);
        this.add((Widget)versionColumn);
        Column versionPanel = new Column(5);
        versionPanel.add(WikiVersionsHandler.linkToVersion((WikiVersionsWidget)this._parent, (WikiVersionTeaser)this._version));
        Integer restoredVersion = this._version.getRestoredVersion();
        if (restoredVersion != null) {
            Label l1 = new Label(" (" + WIKI_EDITOR.restoredFrom() + " ");
            l1.addStyleName("inline");
            versionPanel.add((Widget)l1);
            versionPanel.add(WikiVersionsHandler.linkToVersion((WikiVersionsWidget)this._parent, (int)restoredVersion, (WikiVersionId)this._version.getRestoredVersionId()));
            Label l2 = new Label(")");
            l2.addStyleName("inline");
            versionPanel.add((Widget)l2);
        }
        this.add((Widget)versionPanel);
        DateTimeFormat dateFormat = DateTimeFormat.getFormat((String)BASIC.dateFormatFixedWidth());
        DateTimeFormat timeFormat = DateTimeFormat.getFormat((String)BASIC.timeFormatFixedWidth());
        this.add((Widget)new Column(3, new Widget[]{new Label(dateFormat.format(this._version.getCreateDate()) + " | " + timeFormat.format(this._version.getCreateDate()), false)}));
        this.add((Widget)new Column(4, new Widget[]{PersonUtil.profileLink((PersonTeaserModel)this._version.getAuthor(), (ClientFactory)clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP)}));
        Column actionColumn = new Column(2);
        boolean bl = isCurrentVersion = this._parent.getWikiEditor() == null || this._parent.getWikiEditor().getCurrentVersion().getId().equals((Object)this._version.getId());
        if (!isCurrentVersion && this._parent.getWikiEditor() != null && this._parent.getWikiEditor().getMay().contains((Object)StaticAction.WIKI_SAVE)) {
            actionColumn.add((Widget)new JCIconOnlyAnchor(IconType.SHARE, this._restoreClickHandler, WIKI_EDITOR.restoreVersion()));
        }
        if (!isCurrentVersion && this._version.getMay().contains(StaticAction.WIKI_DELETE)) {
            actionColumn.add((Widget)new JCIconOnlyAnchor(JucoIconTypes.DELETE, this._deleteClickHandler, WIKI_EDITOR.deleteVersion()));
        }
        this.add((Widget)actionColumn);
        this._versionSelect1.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._versionSelect2.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateVersionRadioButtons();
    }

    private void restore() {
        WikiEditorMediator.getInstance().restoreVersion(this._version.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    void updateVersionRadioButtons() {
        this._versionSelect2.setEnabled(this._versionSelect1.getValue() == false);
        this._versionSelect1.setEnabled(this._versionSelect2.getValue() == false);
    }
}

