/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui.presenters;

import com.google.common.annotations.VisibleForTesting;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.survey.presentation.client.SurveyClientFactory;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyCreateOrEditHandler;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyListView;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SurveyListPresenter
implements SurveyListView.Presenter {
    @VisibleForTesting
    public static final int TEASERS_PER_PAGE = 10;
    private final EntityId _parentId;
    private final SurveyListView _view;
    private final SurveyClientFactory _clientFactory;
    private final SurveyConstants _i18nConstants;
    private int _offset = 0;

    public SurveyListPresenter(EntityId parentId, SurveyClientFactory clientFactory, SurveyConstants i18nConstants) {
        this._parentId = parentId;
        this._clientFactory = clientFactory;
        this._i18nConstants = i18nConstants;
        this._view = this._clientFactory.listView((SurveyListView.Presenter)this);
        this._view.setPagerVisible(false);
        this._view.setNoSurveysLabelVisible(false);
        this._view.setAddButtonVisible(false);
        this._clientFactory.controller().mayCreateSurvey(parentId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.loadTeasers();
    }

    private void loadTeasers() {
        this._view.setWaitIndicatorVisibility(true);
        this._clientFactory.controller().getSurveyTeasersByParentId((GlobalId)this._parentId, this._offset, 10, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    public IsWidget getView() {
        return this._view;
    }

    public void nextPage() {
        this._offset += 10;
        this.loadTeasers();
    }

    public void previousPage() {
        this._offset -= 10;
        this.loadTeasers();
    }

    public String getCreateNewSurveyTargetHistoryToken() {
        return SurveyCreateOrEditHandler.token(null, (GlobalId)this._parentId, (int)0);
    }
}

