/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.ValidatorPanel;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.survey.presentation.client.ui.ConfigSurveyQuestionWidget;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsHandler;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyTab;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import java.util.ArrayList;
import java.util.List;

public class ConfigSurveyQuestionWidget
extends Composite
implements SurveyTab {
    private static final ConfigSurveyQuestionWidgetUIBinder UI_BINDER = (ConfigSurveyQuestionWidgetUIBinder)GWT.create(ConfigSurveyQuestionWidgetUIBinder.class);
    private static final SingleAnswerConfigWidgetUIBinder ANSWER_UI_BINDER = (SingleAnswerConfigWidgetUIBinder)GWT.create(SingleAnswerConfigWidgetUIBinder.class);
    private static final SingleQuestionConfigWidgetUIBinder QUESTION_UI_BINDER = (SingleQuestionConfigWidgetUIBinder)GWT.create(SingleQuestionConfigWidgetUIBinder.class);
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    private static final SurveyMessages SURVEY_MSG = I18nMediator.SURVEY_MSG;
    @UiField
    FlowPanel _questionsPanel;
    @UiField
    JCButton _addQuestionButton;
    @UiField
    JCButton _cancelButton;
    @UiField
    JCButton _submitButton;
    @UiField
    InlineFeedbackWidget _errorPanel;
    private final DBSurvey _survey;
    private final List<DBSurveyQuestion> _questions;
    private final List<SingleQuestionConfigWidget> _questionConfigWidgets;
    private final ValidatorPanel.ValidatorPanelUtils _validatorPanelUtils = new ValidatorPanel.ValidatorPanelUtils();
    private int _idCount = 0;
    private final boolean _surveyWasActive;
    private final LoadingDialog _loadingDialog = new LoadingDialog();
    private final ClientFactory _clientFactory;

    public ConfigSurveyQuestionWidget(DBSurvey survey, ClientFactory clientFactory) {
        this._survey = survey;
        this._clientFactory = clientFactory;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        if (CollectionUtil.isEmpty((Iterable)this._survey.getQuestions())) {
            this._questions = new ArrayList();
            this._questions.add(this.createNewQuestion());
            this._surveyWasActive = false;
        } else {
            this._questions = this._survey.getQuestions();
            this._surveyWasActive = true;
        }
        this._questionConfigWidgets = new ArrayList(this._questions.size() + 10);
        for (DBSurveyQuestion question : this._questions) {
            this.addQuestionConfigWidget(question);
        }
    }

    private void addQuestionConfigWidget(DBSurveyQuestion question) {
        SingleQuestionConfigWidget questionConfigWidget = new SingleQuestionConfigWidget(this, question);
        this._questionConfigWidgets.add(questionConfigWidget);
        this._questionsPanel.add((Widget)questionConfigWidget);
    }

    private DBSurveyQuestion createNewQuestion() {
        DBSurveyQuestion question = new DBSurveyQuestion();
        question.setOrder(this._questions.size() + 1);
        question.setSurveyId(this._survey.getId());
        question.setMaxAnswers(Integer.valueOf(1));
        question.setMinAnswers(Integer.valueOf(1));
        return question;
    }

    public void onTabShow() {
        for (SingleQuestionConfigWidget question : this._questionConfigWidgets) {
            question.onTabShow();
        }
    }

    @UiHandler(value={"_addQuestionButton"})
    void handleAddQuestion(ClickEvent event) {
        DBSurveyQuestion question = this.createNewQuestion();
        this.addQuestionConfigWidget(question);
        this._questions.add(question);
    }

    @UiHandler(value={"_submitButton"})
    void handleSubmit(ClickEvent event) {
        this.saveQuestions();
    }

    @UiHandler(value={"_cancelButton"})
    void handleCancel(ClickEvent event) {
        if (this._survey.getId() == null) {
            History.back();
        } else {
            History.newItem((String)SurveyDetailsHandler.token((SurveyId)this._survey.getId(), (boolean)false));
        }
    }

    private void saveQuestions() {
        boolean hasError = false;
        this._errorPanel.setVisible(false);
        try {
            this._validatorPanelUtils.validate();
        }
        catch (ValidationException e) {
            hasError = true;
            this._errorPanel.showAndHideAfterDelay();
        }
        if (!hasError) {
            SaveErrorHandlingAsyncCallback saveCallback = new SaveErrorHandlingAsyncCallback(this);
            if (!this._surveyWasActive) {
                ConfirmPopup.makeConfirmPopup((String)SURVEY.publishSurveyWarning(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, null, (String)SURVEY.publishLabel(), (String)SURVEY.backToQuestionConfigLabel()).center();
            } else {
                this._loadingDialog.center();
                this._clientFactory.surveyClientFactory().controller().saveQuestions(this._survey.getId(), this._questions, false, (AsyncCallback)saveCallback);
            }
        }
    }

    private void updateQuestionOrders() {
        for (int i = 0; i < this._questionConfigWidgets.size(); ++i) {
            ((SingleQuestionConfigWidget)this._questionConfigWidgets.get(i)).setOrder(i + 1);
        }
    }
}

