/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server;

import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.server.StaticSessionListener;
import de.justsoftware.onx.common.shared.util.Numbers;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class SessionTimeoutConfigurer
implements HttpSessionListener,
SuperopertyChangeListener {
    private static final int MINIMUM_SESSION_TIMEOUT = Numbers.longToInt((long)TimeUnit.MINUTES.toSeconds(30L));
    private final Settings _settings;
    private final boolean _hasTimeOut;
    private final int _sessionTimeout;
    private int _minimumSessionLifetimeSeconds;

    @Autowired
    public SessionTimeoutConfigurer(@Value(value="${sessionTimeout}") int timeout, Settings settings) {
        this._settings = settings;
        this._hasTimeOut = timeout > 0;
        this._sessionTimeout = Numbers.longToInt((long)TimeUnit.MINUTES.toSeconds(timeout));
        this._minimumSessionLifetimeSeconds = MINIMUM_SESSION_TIMEOUT;
        StaticSessionListener.addSessionListener((HttpSessionListener)this);
    }

    public void sessionCreated(HttpSessionEvent event) {
        int maxInactiveInterval = this._hasTimeOut ? this._sessionTimeout + this._minimumSessionLifetimeSeconds : -1;
        event.getSession().setMaxInactiveInterval(maxInactiveInterval);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    public void superopertyChange(SuperopertyChangeEvent event) {
        this.updatePollingInterval();
    }

    private void updatePollingInterval() {
        int clientPollingInterval = this._settings.getClientPollingInterval();
        this._minimumSessionLifetimeSeconds = clientPollingInterval > 0 ? clientPollingInterval : MINIMUM_SESSION_TIMEOUT;
    }

    @PostConstruct
    public void addSuperopertyChangeListener() {
        this._settings.getClientPollingIntervalProperty().addSuperopertyChangeListener((SuperopertyChangeListener)this);
        this.updatePollingInterval();
    }
}

