/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.shared.i18n.SearchConstants;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.presentation.client.UserInfo;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.logging.client.ClientLogger;
import de.justsoftware.onx.searchnew.presentation.client.SingleSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSingleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MySearchContextFilterDataProvider
implements AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider<SearchContextFacet> {
    private final SearchConstants _searchConstants;
    private final UserInfo _userInfo;
    private final ClientLogger _clientLogger;
    private final boolean _alwaysShowSearchContextFilter;

    public MySearchContextFilterDataProvider(SearchConstants searchConstants, boolean alwaysShowSearchContextFilter, UserInfo userInfo, ClientLogger clientLogger) {
        this._searchConstants = searchConstants;
        this._alwaysShowSearchContextFilter = alwaysShowSearchContextFilter;
        this._userInfo = userInfo;
        this._clientLogger = clientLogger;
    }

    public void withSelectionLinks(SearchParameters parameters, AbstractSingleSelectionFilterPresenter.SelectionLinksAvailableCallback<SearchContextFacet> callback) {
        SearchContext selectedContext = parameters.getSearchContext();
        PersonId userId = this._userInfo.getLoggedInPersonId();
        if (userId == null) {
            this._clientLogger.error((Object)this, "MySearchContextFilterProvider is used by a not logged in user");
            return;
        }
        PersonId contextId = (PersonId)MoreObjects.firstNonNull((Object)PersonId.valueOf((ProfileId)parameters.getContextProfileId()), (Object)userId);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.addFilterLink(builder, IconType.GLOBE, this._searchConstants.allMyContents(), SearchContext.MY_CONTENT, contextId, selectedContext, true);
        this.addFilterLink(builder, IconType.TROPHY, this._searchConstants.myContentWhereIamAdmin(), SearchContext.ADMIN, contextId, selectedContext, false);
        this.addFilterLink(builder, IconType.CHECK, this._searchConstants.myContentWhereIamMember(), SearchContext.MEMBER, contextId, selectedContext, false);
        if (contextId.equals((Object)userId)) {
            this.addFilterLink(builder, IconType.THUMBS_UP, this._searchConstants.myContentWhereISubscribed(), SearchContext.SUBSCRIPTION, contextId, selectedContext, false);
        }
        callback.setSelections(builder.build());
    }

    private void addFilterLink(ImmutableList.Builder<SingleSelectionFilterLink<SearchContextFacet>> linkList, IconType icon, String label, SearchContext linkSearchContext, PersonId userId, SearchContext selectedContext, boolean defaultSelection) {
        Optional searchContextFacet = SearchContextFacet.forContext((SearchContext)linkSearchContext, null, (PersonId)userId);
        if (searchContextFacet.isPresent()) {
            linkList.add((Object)new SingleSelectionFilterLink(icon, label, selectedContext == linkSearchContext, (Object)((SearchContextFacet)searchContextFacet.get()), defaultSelection));
        }
    }

    public boolean isFilterApplicable(SearchParameters searchParameters) {
        SearchContext selectedContext = searchParameters.getSearchContext();
        return selectedContext != null && selectedContext.isMyContentContext();
    }

    public String getFilterHeader() {
        return this._searchConstants.relationToContent();
    }

    public SearchParameters withSelection(SearchParameters searchParameters, SearchContextFacet searchFacet) {
        return searchParameters.withSearchContext(searchFacet.getSearchContext());
    }

    public boolean isRestrictionSelected(SearchParameters searchParameters) {
        return this._alwaysShowSearchContextFilter || searchParameters.getSearchContextOrEntirePlatform() != SearchContext.MY_CONTENT;
    }
}

