/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.gwt.user.client.History;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.SingleSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSearchSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSingleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SelectionFilterView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionFilterView;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.Nonnull;

public abstract class AbstractSingleSelectionFilterPresenter<T>
extends AbstractSearchSelectionFilterPresenter
implements SingleSelectionFilterView.Presenter<T> {
    protected final SingleSelectionFilterView<T> _view;
    protected final SingleSelectionFilterLinkDataProvider<T> _dataProvider;
    protected ImmutableMap<T, SingleSelectionFilterLink<T>> _currentLinks = ImmutableMap.of();
    private Optional<SingleSelectionFilterLink<T>> _defaultSelection;

    public AbstractSingleSelectionFilterPresenter(@Nonnull SearchClientFactory factory, @Nonnull SingleSelectionFilterLinkDataProvider<T> dataProvider, @Nonnull SearchParameters searchParameters) {
        super(dataProvider, searchParameters);
        this._dataProvider = dataProvider;
        this._view = factory.getSingleSelectionFilterView((SingleSelectionFilterView.Presenter)this);
        this._view.setFilterHeader(this._dataProvider.getFilterHeader());
        this.onSearchParametersChanged(searchParameters);
    }

    protected SelectionFilterView getView() {
        return this._view;
    }

    protected void onSearchParametersChanged() {
        this._dataProvider.withSelectionLinks(this.getSearchParameters(), (SelectionLinksAvailableCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onSelected(T selection) {
        History.newItem((String)SearchHandler.tokenFor((SearchParameters)this._dataProvider.withSelection(this.getSearchParameters(), selection)));
    }

    public void onSelectionRemoved(T selection) {
        if (this._defaultSelection.isPresent()) {
            SingleSelectionFilterLink defaultSelectionLink = (SingleSelectionFilterLink)this._defaultSelection.get();
            History.newItem((String)SearchHandler.tokenFor((SearchParameters)this._dataProvider.withSelection(this.getSearchParameters(), defaultSelectionLink.getSelection())));
            this._view.setSelectedFilter(defaultSelectionLink, false);
        }
    }
}

