/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client;

import com.freiheit.toro.client.mediator.HistoryItemHandler;
import com.freiheit.toro.client.mediator.HistoryTokenAndHandler;
import com.freiheit.toro.client.mediator.HistoryTokenState;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.container.presentation.client.ui.WidgetPartOfEntityHistoryItemHandler;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultPageView;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchResultViewType;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterListModel;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterModel;
import de.justsoftware.onx.searchnew.shared.model.SearchTokenUtil;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class SearchHandler
extends WidgetPartOfEntityHistoryItemHandler {
    private final Map<SearchResultViewType, SearchResultPageView.Presenter> _presenters = Maps.newHashMap();
    private String _entryToken = "";

    public SearchHandler(ClientFactory clientFactory) {
        super(clientFactory);
    }

    @Nonnull
    private SearchParameters getDefaultParameters() {
        SearchTextBoxFilterListModel searchTextBoxFilters = HostPropertiesMediator.getHostPropertiesBean().getSearchTextBoxFilters();
        SearchTextBoxFilterModel defaultFilter = (SearchTextBoxFilterModel)searchTextBoxFilters.getFilters().get((Object)searchTextBoxFilters.getDefaultfilter());
        if (defaultFilter != null) {
            return defaultFilter.toSearchParameters(null);
        }
        return new SearchParameters(null, (FilterType)StaticFilterType.ALL, SearchContext.ENTIRE_PLATFORM, null, null, null, null, SearchProviderId.JUCO_ID, (SearchFacetParameters)StaticSearchFacetParameters.DEFAULT_FACETS);
    }

    public void createWidget(ClientFactory clientFactory, HistoryTokenState state, HistoryItemHandler.WidgetCreatedCallback callback, PageTitleCallback titleCallback) {
        HistoryTokenAndHandler previousHistoryTokenAndHandler;
        TokenUtil.TokenIdAndParams tokenIdAndParams = state.getTokenIdAndParams();
        SearchParameters searchParameters = SearchHandler.fromParams((List)tokenIdAndParams.getParams());
        String previousToken = state.getPreviousHistoryItem();
        if (previousToken != null && (previousHistoryTokenAndHandler = clientFactory.historyManager().getTokenAndHandlerForHistoryItem(previousToken)) != null && !previousHistoryTokenAndHandler.getToken().getTokenId().equals((Object)tokenIdAndParams.getTokenId())) {
            this._entryToken = previousToken;
        }
        this.createSearchResultPage(searchParameters.withFallbacks(ClientSearchConfigurationProvider.INSTANCE, this.getDefaultParameters()), callback, this._entryToken, SearchResultViewType.fromParam((String)tokenIdAndParams.getString(7)));
        String keyword = searchParameters.getText();
        String pageTitle = Strings.isNullOrEmpty((String)keyword) ? I18nMediator.SEARCH_MESSAGES.pageTitleNoKeyword() : I18nMediator.SEARCH_MESSAGES.pageTitleWithKeyword(keyword);
        titleCallback.setPageTitle(pageTitle);
    }

    private void createSearchResultPage(SearchParameters searchParameters, HistoryItemHandler.WidgetCreatedCallback callback, String entryToken, SearchResultViewType targetViewType) {
        SearchResultPageView.Presenter presenter = this.refreshOrCreatePresenter(searchParameters, entryToken, targetViewType);
        callback.onWidgetCreated(presenter.getView().asWidget());
    }

    @Nonnull
    private SearchResultPageView.Presenter refreshOrCreatePresenter(SearchParameters searchParameters, String entryToken, SearchResultViewType targetViewType) {
        SearchResultPageView.Presenter presenter = (SearchResultPageView.Presenter)Optional.fromNullable((Object)((SearchResultPageView.Presenter)this._presenters.get(targetViewType))).or((Object)this.createPresenter(targetViewType));
        presenter.setSearchParameters(searchParameters);
        presenter.setBackLinkToken(entryToken);
        this._presenters.put(targetViewType, presenter);
        return presenter;
    }

    @Nonnull
    private SearchResultPageView.Presenter createPresenter(SearchResultViewType targetViewType) {
        switch (1.$SwitchMap$de$justsoftware$onx$searchnew$shared$model$SearchResultViewType[targetViewType.ordinal()]) {
            case 1: {
                return this._clientFactory.searchFactory().createSearchFilterEditPagePresenter();
            }
        }
        return this._clientFactory.searchFactory().createSearchResultPagePresenter();
    }

    @Nonnull
    private SearchResultPageView.Presenter refreshOrCreateOldPresenter(SearchParameters searchParameters, String entryToken) {
        SearchResultPageView.Presenter presenter = (SearchResultPageView.Presenter)this._presenters.get(SearchResultViewType.RESULT_LIST);
        if (presenter == null) {
            presenter = this._clientFactory.searchFactory().createOldSearchResultPagePresenter(searchParameters, entryToken);
            this._presenters.put(SearchResultViewType.RESULT_LIST, presenter);
        } else {
            presenter.setSearchParameters(searchParameters);
            presenter.setBackLinkToken(entryToken);
        }
        return presenter;
    }

    public Object[] getDefaultParams() {
        return SearchTokenUtil.toSearchTokenParamArray((SearchParameters)SearchTokenUtil.defaultSearchParameters(), (SearchResultViewType)SearchResultViewType.getDefault());
    }

    public String getParamTypes() {
        return "SSSLLSSS";
    }

    public void getItemIdOfWidget(List<?> params, AsyncCallback<GlobalId> callback) {
        callback.onSuccess((Object)SearchHandler.fromParams(params).getContextId());
    }

    @Nonnull
    public static String tokenFor(SearchParameters input) {
        return SearchHandler.tokenFor((SearchParameters)input, (ClientFactory)ClientFactoryImpl.INSTANCE);
    }

    @Nonnull
    public static String tokenFor(SearchParameters input, ClientFactory clientFactory) {
        return SearchHandler.tokenFor((SearchParameters)input, (SearchResultViewType)SearchResultViewType.getDefault(), (ClientFactory)clientFactory);
    }

    @Nonnull
    public static String tokenFor(SearchParameters input, @Nullable SearchResultViewType targetViewType, ClientFactory clientFactory) {
        ProfileId profileId = input.getContextProfileId();
        if (HistoryToken.ENTITY.equals((Object)input.getToken())) {
            ImmutableList contextHierarchy = input.getContextHierarchy();
            EntityId contextId = input.getContextEntityId();
            if (contextHierarchy.isEmpty() && contextId != null) {
                return EntityOverviewHandler.token((EntityId)contextId, (SearchParameters)input);
            }
            EntityId entityId = (EntityId)Iterables.getFirst((Iterable)contextHierarchy, null);
            if (entityId != null) {
                return EntityOverviewHandler.token((EntityId)entityId, (SearchParameters)input);
            }
        } else if (HistoryToken.PROFILE.equals((Object)input.getToken()) && profileId != null) {
            return ReactProfileComponent.token((PersonId)profileId.asPersonId(), (SearchParameters)input);
        }
        return clientFactory.historyManager().createHistoryItem(HistoryToken.SEARCH_TEXT, SearchTokenUtil.toSearchTokenParamArray((SearchParameters)input, (SearchResultViewType)targetViewType));
    }

    @Nonnull
    public static String tokenForMyContents(FilterType filter) {
        return SearchHandler.tokenFor((SearchParameters)SearchHandler.parameters((FilterType)filter, (SearchContext)SearchContext.MY_CONTENT).withDefaultSortTypeAndSubfilter(ClientSearchConfigurationProvider.INSTANCE));
    }

    @Nonnull
    public static SearchParameters parameters(@Nullable String searchTerm) {
        return SearchHandler.parameters((String)searchTerm, (FilterType)StaticFilterType.PROFILES, (SearchContext)SearchContext.ENTIRE_PLATFORM, null, null, null, (SearchProviderId)SearchProviderId.JUCO_ID);
    }

    @Nonnull
    public static SearchParameters parameters(EntityDetailsPublicData entity) {
        return SearchHandler.parameters((String)"", null, (SearchContext)SearchContext.ENTITY, (EntityId)((EntityId)entity.getId()), null, null, (SearchProviderId)SearchProviderId.JUCO_ID);
    }

    @Nonnull
    public static SearchParameters parameters(@Nullable FilterType filterType, @Nullable SearchContext context) {
        return SearchHandler.parameters((String)"", (FilterType)filterType, (SearchContext)context, null, null, null, (SearchProviderId)SearchProviderId.JUCO_ID);
    }

    @Nonnull
    public static SearchParameters parameters(@Nullable FilterType filterType, @Nullable SearchContext context, EntityId entityId) {
        return SearchHandler.parameters((String)"", (FilterType)filterType, (SearchContext)context, (EntityId)entityId, null, null, (SearchProviderId)SearchProviderId.JUCO_ID);
    }

    @Nonnull
    public static <T extends Identifiable<EntityId>> SearchParameters parameters(@Nullable FilterType filterType, @Nullable SearchContext context, T entity) {
        return SearchHandler.parameters((String)"", (FilterType)filterType, (SearchContext)context, (EntityId)((EntityId)entity.getId()), null, null, (SearchProviderId)SearchProviderId.JUCO_ID);
    }

    @Nonnull
    public static SearchParameters entitySpecificParameters(EntityDetailsPublicData entity, FilterType filterType) {
        SearchParameters result = SearchHandler.parameters((String)"", (FilterType)filterType, (SearchContext)SearchContext.ENTITY, (EntityId)((EntityId)entity.getId()), null, null, (SearchProviderId)SearchProviderId.JUCO_ID).withDefaultSortTypeAndSubfilter(ClientSearchConfigurationProvider.INSTANCE).withHistoryToken(HistoryToken.ENTITY);
        if (filterType == StaticFilterType.DOCUMENTS) {
            return result.withSubfilters((Set)ImmutableSet.copyOf((Iterable)FluentIterable.from((Iterable)result.getSubfilter()).filter(Predicates.not((Predicate)Predicates.in(EnumSet.allOf(ArchiveSubFilter.class))))));
        }
        return result;
    }

    @Nonnull
    private static SearchParameters fromParams(List<?> params) {
        return SearchTokenUtil.convertParamsToSearchParameters(params, (EntityId)EntityMediator.getInstance().getCurrentEntityId());
    }

    @Nonnull
    private static SearchParameters parameters(@Nullable String searchString, @Nullable FilterType filter, @Nullable SearchContext context, @Nullable EntityId entityId, @Nullable SortType sortType, @Nullable Set<SubFilter> subfilter, SearchProviderId provider) {
        return new SearchParameters(searchString, filter, context, (GlobalId)entityId, null, sortType, subfilter, provider, (SearchFacetParameters)StaticSearchFacetParameters.DEFAULT_FACETS);
    }
}

