/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.polling.presentation.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.requestcollect.client.IRequestBundler;
import de.justsoftware.gwt.requestcollect.client.RequestCollectorControl;
import de.justsoftware.gwt.user.client.TimerCallback;
import de.justsoftware.gwt.user.client.TimerControl;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.polling.presentation.shared.PollingRemoteServiceAsync;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class PollTimer {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final long LONG_DURATION_UNTIL_RECHECK = 60000L;
    @VisibleForTesting
    final AsyncCallback<Integer> _intervalCallback = new /* Unavailable Anonymous Inner Class!! */;
    @VisibleForTesting
    final IRequestBundler _bundler = new /* Unavailable Anonymous Inner Class!! */;
    @VisibleForTesting
    final TimerCallback _timerCallback = new /* Unavailable Anonymous Inner Class!! */;
    private long _lastCheck = Long.MIN_VALUE;
    private int _count = 0;
    private int _currentInterval = 0;
    private boolean _checkInterval = true;
    private final TimerControl _timer;
    private final RequestCollectorControl _requestCollector;
    private final EventManager _eventManager;
    private final PollingRemoteServiceAsync _pollingRemoteService;

    private PollTimer(ClientFactory clientFactory) {
        this._eventManager = clientFactory.eventManager();
        this._pollingRemoteService = clientFactory.pollingClientFactory().pollingRemoteService();
        this._requestCollector = clientFactory.requestCollector();
        this._timer = clientFactory.timer(this._timerCallback);
        this._requestCollector.registerParasiteBundler(this._bundler);
        this._bundler.bundleRequests();
    }

    private void reschedule() {
        if (this._currentInterval > 0) {
            this._timer.scheduleRepeating(1000 * this._currentInterval);
        } else {
            this._timer.cancel();
        }
    }

    @Nonnull
    public static PollTimer start(ClientFactory clientFactory) {
        return new PollTimer(clientFactory);
    }

    private void markIntervalUptodate() {
        this._lastCheck = System.currentTimeMillis();
    }
}

