/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.shared;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.ValidationResult;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import de.justsoftware.onx.person.shared.model.PersonDetailsModel;
import de.justsoftware.onx.person.shared.model.PersonPopupModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.settings.ProfileSettings;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@RemoteServiceRelativePath(value="/person")
public interface PersonController
extends RemoteService {
    public static final String URL = "/person";

    public PersonDetailsModel getPersonDetailsModelById(PersonId var1) throws ServiceException;

    public Map<PersonId, PersonTeaserModel> getPersonTeaserModelsByIds(ImmutableSet<PersonId> var1) throws ServiceException;

    @CheckForNull
    public PersonTeaserModel getPersonTeaserModelById(@Nonnull PersonId var1) throws ServiceException;

    public void deleteAccount(@Nonnull String var1) throws ServiceException;

    public void deleteAccountAsSuperadmin(@Nonnull PersonId var1) throws ServiceException;

    public void changeLanguageForLoggedInUser(String var1) throws ServiceException;

    public DBAccountSettings getAccountSettings(@Nonnull PersonId var1) throws ServiceException;

    public List<ValidationResult> validatePassword(String var1);

    @CheckForNull
    public EmailNotificationSettingsBean getEmailNotificationSettings(PersonId var1) throws ServiceException;

    @Nonnull
    public ProfileSettings getProfileSettings(@Nullable PersonId var1) throws ServiceException;

    public void updateEmailNotificationSettings(@Nonnull EmailNotificationSettingsBean var1) throws ServiceException;

    public void setPersonBlocked(@Nonnull PersonId var1, boolean var2) throws ServiceException, ValidatableException;

    public void setActivated(@Nonnull PersonId var1, boolean var2) throws ServiceException;

    @CheckForNull
    public PersonPopupModel getPersonPopupModelById(@Nonnull PersonId var1, @Nonnull ImmutableSet<? extends Action> var2);

    @Nonnull
    public DBAccountSettings updateOwnEmailAddress(@Nonnull String var1, @Nonnull String var2) throws ServiceException, ValidatableException;

    @Nonnull
    public DBAccountSettings updateEmailAddressForDifferentUser(@Nonnull PersonId var1, @Nonnull String var2) throws ServiceException, ValidatableException;

    @Nonnull
    public DBAccountSettings updateOwnPassword(@Nonnull String var1, @Nonnull String var2) throws ServiceException, ValidatableException;

    @Nonnull
    public DBAccountSettings updatePasswordForDifferentUser(@Nonnull PersonId var1, @Nonnull String var2) throws ServiceException, ValidatableException;
}

