/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.views;

import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.Lists;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.FoldUtil;
import de.justsoftware.onx.common.presentation.client.ui.InfoBoxWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.container.presentation.client.ui.JustEntityAppWidget;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiSectionView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiSectionViewImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiSectionViewImpl
extends Composite
implements MultiWikiSectionView {
    private static final MultiWikiSectionViewUiBinder BINDER = (MultiWikiSectionViewUiBinder)GWT.create(MultiWikiSectionViewUiBinder.class);
    @UiField
    InfoBoxWidget _container;
    @UiField
    SimplePanel _sectionHeadlineContainer;
    @UiField
    SimplePanel _sectionVisibilityContainer;
    @UiField
    JCIconOnlyAnchor _foldAction;
    @UiField
    JCIconOnlyAnchor _moveUpAction;
    @UiField
    JCIconOnlyAnchor _moveDownAction;
    @UiField
    JCIconOnlyAnchor _deleteAction;
    @UiField
    SimplePanel _editorContainer;
    private final MultiWikiSectionView.Presenter _presenter;

    public MultiWikiSectionViewImpl(MultiWikiSectionView.Presenter presenter) {
        this._presenter = presenter;
        this.initWidget((Widget)BINDER.createAndBindUi((Object)this));
    }

    public AcceptsOneWidget getHeadlineContainer() {
        return this._sectionHeadlineContainer;
    }

    public void setFoldIconType(IconType icon) {
        this._foldAction.setIcon(icon);
    }

    public void setContentVisible(boolean visible) {
        this._container.setStyleName("folded", !visible);
        this._container.setContentVisible(visible);
    }

    public AcceptsOneWidget getVisibilityContainer() {
        return this._sectionVisibilityContainer;
    }

    public AcceptsOneWidget getEditorContainer() {
        return this._editorContainer;
    }

    @UiHandler(value={"_foldAction"})
    void onFold(ClickEvent ev) {
        this._presenter.onFold();
    }

    @UiHandler(value={"_moveUpAction"})
    void onMoveUp(ClickEvent e) {
        this._presenter.onMoveUp();
    }

    @UiHandler(value={"_moveDownAction"})
    void onMoveDown(ClickEvent e) {
        this._presenter.onMoveDown();
    }

    @UiHandler(value={"_deleteAction"})
    void onDelete(ClickEvent e) {
        this._presenter.onDelete();
    }

    public void setMoveUpEnabled(boolean enabled) {
        this._moveUpAction.setEnabled(enabled);
        this._moveUpAction.setStyleName("disabled", !enabled);
    }

    public void setMoveDownEnabled(boolean enabled) {
        this._moveDownAction.setEnabled(enabled);
        this._moveDownAction.setStyleName("disabled", !enabled);
    }

    public void setMoveActionsVisible(boolean visible) {
        this._moveUpAction.setVisible(visible);
        this._moveDownAction.setVisible(visible);
    }

    public void setDeleteActionVisible(boolean visible) {
        this._deleteAction.setVisible(visible);
    }

    public void setDeleteEnabled(boolean enabled) {
        this._deleteAction.setEnabled(enabled);
        this._deleteAction.setStyleName("disabled", !enabled);
    }

    public Element getHeadingElement(int position) {
        List headingElements = this.findAllHeadings((Element)this._editorContainer.getElement());
        if (headingElements.size() <= position) {
            return null;
        }
        return (Element)headingElements.get(position);
    }

    public void openParentsAndScrollTo(@Nullable Element headingElement) {
        if (headingElement == null) {
            com.google.gwt.user.client.Element element = this.getElement();
            FoldUtil.openParents((Element)element);
            JustEntityAppWidget.scrollElementIntoViewTopAligned((Element)element);
        } else {
            FoldUtil.openParents((Element)headingElement);
            JustEntityAppWidget.scrollElementIntoViewTopAligned((Element)headingElement);
        }
    }

    @Nonnull
    private List<Element> findAllHeadings(Element element) {
        ArrayList headingTags = Lists.newArrayList((Object[])new String[]{"h1", "h2", "h3", "h4", "h5", "h6"});
        ArrayList<Element> res = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.getItem(i);
            if (item.getNodeType() != 1) continue;
            Element childElement = (Element)item;
            if (headingTags.contains(childElement.getNodeName().toLowerCase())) {
                res.add((Element)item);
            }
            res.addAll(this.findAllHeadings((Element)item));
        }
        return res;
    }

    protected void onLoad() {
        super.onLoad();
        FoldUtil.setOpenCallback((Element)this._editorContainer.getElement(), (FoldUtil.OpenCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onUnload() {
        FoldUtil.removeOpenCallback((Element)this._editorContainer.getElement());
        super.onUnload();
    }
}

