/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.components.InlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.MultipleOptionsInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiEditorPresenter;
import de.justsoftware.onx.person.shared.model.PersonRolesClientTranslation;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiSectionVisibilitiesPresenter
implements InlineEditView.Presenter {
    private final MultipleOptionsInlineEditView _view;
    private ImmutableList<String> _currentlySelectedRoles = ImmutableList.of();
    private ImmutableList<String> _savedSelectedRoles = ImmutableList.of();
    private final ImmutableList<AuthorityModel> _availableAuthorities;
    private final ImmutableSet<String> _allowedVisibleRoles;
    private final BasicMessages _basicMessages;
    private final BasicConstants _basicConstants;
    private final PersonRolesClientTranslation _roleTranslations;
    private final MultiWikiEditorPresenter.EditHandler _editHandler;

    public MultiWikiSectionVisibilitiesPresenter(EditorClientFactory editorFactory, ImmutableList<String> selectedRoles, boolean mayEdit, MultiWikiEditorPresenter.EditHandler editHandler, PersonRolesClientTranslation roleTranslations, BasicMessages basicMessages, BasicConstants basicConstants, ImmutableList<AuthorityModel> availableAuthorities) {
        this._editHandler = editHandler;
        this._view = mayEdit ? editorFactory.getMultiWikiSectionVisibilitiesView((InlineEditView.Presenter)this) : editorFactory.getMultiOptionsReadOnlyView();
        this._availableAuthorities = availableAuthorities;
        this._allowedVisibleRoles = FluentIterable.from((Iterable)this._availableAuthorities).filter(AuthorityModel.IS_VISIBLE).transform(AuthorityModel.TO_NAME).toSet();
        this._roleTranslations = roleTranslations;
        this._basicMessages = basicMessages;
        this._basicConstants = basicConstants;
        this.setVisibilities(selectedRoles);
        this._view.showLabel();
    }

    public void showIn(AcceptsOneWidget parent) {
        parent.setWidget((IsWidget)(this._allowedVisibleRoles.isEmpty() ? null : this._view));
    }

    public void setVisibilities(ImmutableList<String> selectedRoles) {
        ImmutableList visibleRoles = FluentIterable.from(selectedRoles).filter(Predicates.in((Collection)this._allowedVisibleRoles)).toList();
        this._savedSelectedRoles = ImmutableList.copyOf((Collection)visibleRoles);
        this._currentlySelectedRoles = ImmutableList.copyOf((Collection)visibleRoles);
        this._view.clearOptions();
        this.initLabel(visibleRoles);
        this.initEditor(visibleRoles);
        this._view.marksAsDirty(false);
        this._view.showLabel();
    }

    private void initLabel(ImmutableList<String> selectedRoles) {
        String label = selectedRoles.isEmpty() ? this._basicMessages.visibleForRoles("-") : this._basicMessages.visibleForRoles(Joiner.on((String)", ").join(Iterables.transform(selectedRoles, (Function)this._roleTranslations.translate())));
        this._view.setLabel(label);
    }

    private void initEditor(ImmutableList<String> selectedRoles) {
        this._view.setEditorLabel(this._basicMessages.visibleForRoles(""));
        for (AuthorityModel model : this._availableAuthorities) {
            if (!model.isVisible()) continue;
            String role = model.getAuthority();
            String label = this._roleTranslations.getDisplayName(role);
            boolean currentlySelected = model.isForced() || selectedRoles.contains((Object)role);
            boolean editable = !model.isForced();
            String infoText = editable ? null : this._basicConstants.listItemPanelRemoveNotPossibleText();
            this._view.addOption(label, role, currentlySelected, editable, infoText, (MultipleOptionsInlineEditView.SelectionChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void handleChange() {
        this.initLabel(this._currentlySelectedRoles);
        this._view.marksAsDirty(this.isDirty());
        this._editHandler.onChange();
    }

    public void cancel() {
        this.setVisibilities(this._savedSelectedRoles);
        this._view.showLabel();
    }

    public void edit() {
        if (this._editHandler.onEdit(null)) {
            this._view.showEditor();
        }
    }

    public void save() {
        this.blur();
    }

    public void blur() {
        this.handleChange();
        this._view.showLabel();
    }

    @Nonnull
    public ImmutableList<String> getSelectedRoles() {
        return this._currentlySelectedRoles;
    }

    public boolean isDirty() {
        return !Objects.equal((Object)this._savedSelectedRoles, (Object)this._currentlySelectedRoles);
    }
}

